-------------------------------------------------------------------------------
-- Copyright (c) 2005 Xilinx, Inc.
-- This design is confidential and proprietary of Xilinx, All Rights Reserved.
-------------------------------------------------------------------------------
--   ____  ____
--  /   /\/   /
-- /___/  \  / Vendor: Xilinx
-- \   \   \/ Version: 1.6
--  \   \ Application : MIG
--  /   / Filename: mem_interface_small_v4_dq_iob.vhd
-- /___/   /\ Date Last Modified:  Wed Jun 1 2005
-- \   \  /  \Date Created: Mon May 2 2005
--  \___\/\___\
-- 
-- Device: Virtex-4
-- Design Name: DDR2_V4
-- Description     : This module places the data in the IOBs.
-------------------------------------------------------------------------------

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.numeric_std.all;

library UNISIM;
use UNISIM.VCOMPONENTS.ALL;

entity mem_interface_small_v4_dq_iob is 
port (
      CLK              : in std_logic;
      CLK90            : in std_logic;
      CAL_CLK          : in std_logic;
      RESET            : in std_logic;
      DATA_DLYINC      : in std_logic; 
      DATA_DLYCE       : in std_logic;  
      DATA_DLYRST      : in std_logic;
      WRITE_DATA_RISE  : in std_logic;
      WRITE_DATA_FALL  : in std_logic;
      CTRL_WREN        : in std_logic;
      DDR_DQ           : inout std_logic;
      READ_DATA_RISE   : out std_logic;
      READ_DATA_FALL   : out std_logic 
      );

end entity;

architecture arc_v4_dq_iob of mem_interface_small_v4_dq_iob is

component IOBUF
port(
    O  : out   std_ulogic;
    IO : inout std_ulogic;
    I  : in    std_ulogic;
    T  : in    std_ulogic
    );
end component;
component FDCE
 port(
      D    : in  std_ulogic;
      CLR  : in  std_ulogic;
      C    : in  std_ulogic;
      Q    : out  std_ulogic;
      CE   : in  std_ulogic
     );               
end component;

component IDELAY
generic(
    IOBDELAY_TYPE  : string := "VARIABLE";
    IOBDELAY_VALUE : integer := 0
    );
port(
    O      : out std_ulogic;
    C      : in  std_ulogic;
    CE     : in  std_ulogic;
    I      : in  std_ulogic;
    INC    : in  std_ulogic;
    RST    : in  std_ulogic
    );
end component;

component IDDR
generic(
        DDR_CLK_EDGE : string := "SAME_EDGE_PIPELINED";
        SRTYPE       : string := "SYNC"
    );
port(
    Q1          : out std_ulogic;
    Q2          : out std_ulogic;
    C           : in  std_ulogic;
    CE          : in  std_ulogic;
    D           : in  std_ulogic;
    R           : in  std_ulogic;
    S           : in  std_ulogic
  );
end component;

component ODDR
generic(
    DDR_CLK_EDGE : string := "SAME_EDGE";
    SRTYPE       : string := "SYNC"
    );
port(
    Q           : out std_ulogic;
    C           : in  std_ulogic;
    CE          : in  std_ulogic;
    D1          : in  std_ulogic;
    D2          : in  std_ulogic;
    R           : in  std_ulogic;
    S           : in  std_ulogic
  );
end component;

signal dq_in          : std_logic;
signal dq_out         : std_logic;
signal dq_delayed     : std_logic;
signal write_en_L     : std_logic;
signal write_en_L_r1  : std_logic;
signal vcc            : std_logic;
signal gnd            : std_logic;

  attribute equivalent_register_removal : string;
  attribute equivalent_register_removal of write_en_L_r1 : signal is "no";
  attribute equivalent_register_removal of tri_state_dq : label is "no";
  attribute iob : string;
  attribute iob of tri_state_dq : label is "TRUE";

begin

  vcc        <= '1';
  gnd        <= '0';
  write_en_L <=  not CTRL_WREN;
  
                                
oddr_dq : ODDR
generic map (
    DDR_CLK_EDGE => "SAME_EDGE",
    SRTYPE       => "SYNC"
    )

          port map (
                    Q  => dq_out,
                    C  => CLK90,
                    CE => vcc,
                    D1 => WRITE_DATA_RISE,
                    D2 => WRITE_DATA_FALL,
                    R  => RESET,
                    S  => gnd
                   );


tri_state_dq : FDCE
                     port map (
                               D    => write_en_L,
                               CLR  => RESET,
                               C    => CLK90,
                               Q    => write_en_L_r1,
                               CE   => vcc
                              );               

            
iobuf_dq : IOBUF
           port map (
                     I  => dq_out,
                     T  => write_en_L_r1,
                     IO => DDR_DQ,
                     O  => dq_in
                    );                    
                   
idelay_dq : IDELAY
generic map (
    IOBDELAY_TYPE  => "VARIABLE",
    IOBDELAY_VALUE =>  0
    )

            port map (
                      O   => dq_delayed,
                      I   => dq_in,
                      C   => CAL_CLK,   
                      CE  => DATA_DLYCE,
                      INC => DATA_DLYINC,
                      RST => DATA_DLYRST
                     );

iddr_dq : IDDR
generic map(
             DDR_CLK_EDGE =>  "SAME_EDGE_PIPELINED",
             SRTYPE       => "SYNC"
           )

          port map (
                    Q1 => READ_DATA_RISE,
                    Q2 => READ_DATA_FALL,
                    C  => CLK,
                    CE => vcc,
                    D  => dq_delayed,
                    R  => RESET,
                    S  => gnd
                   );
              
end arc_v4_dq_iob;                                                 
   
  
  
