#!/usr/bin/env python2
# Tile:		TestHarness.py
# Author:	M.Thomas BEAM Ltd
# Date:		2007-05-09
#
# Contents:	Testing tms API
#

import sys
import os
import os.path
import getopt


class TestCaptureInfo:
	def __init__(s):
		s.data = { 'channel' : "23",'source':"0",'clock': "0",'startTime': "0",'postTriggerDelay': "0",'triggerAnd':"0",'triggerStore':"0",'triggerSourceData':"2" }
	def printIt(s):
		for k,v in s.data.iteritems():
			print k + "=" + v
	def getString(s):
		val = s.data['channel'] + ","
		val += s.data['source'] + ","
		val += s.data['clock'] + ","
		val += s.data['startTime'] + ","
		val += s.data['postTriggerDelay'] + ","
		val += s.data['triggerAnd'] + ","
		val += s.data['triggerAnd'] + ","
		val += s.data['triggerStore'] + ","
		val += s.data['triggerSourceData'] 
		return val;

class DataCaptureInfo:
	def __init__(s):
		s.data = { 'channel' : "23",'period':"0",'startTime': "0",'orbit': "0",'bunch': "0",'numSamples':"0",'function':"0" }
	def printIt(s):
		for k,v in s.data.iteritems():
			print k + "=" + v
	def getString(s):
		val = s.data['channel'] + ","
		val += s.data['period'] + ","
		val += s.data['startTime'] + ","
		val += s.data['orbit'] + ","
		val += s.data['bunch'] + ","
		val += s.data['numSamples'] + ","
		val += s.data['function'] + ","
		return val;

class	TestHarness:
	def __init__(s):
		s.dataFile = "/src/cern/tms/datasrc/beam1-437000-8.psd";
		s.pathTmsControl = "/src/cern/tms/tmsControl/";
		s.host = "";
		s.testName = os.path.basename(sys.argv[0])
		s.parseCmdLine();
		s.setEnv();
		s.testEnv();

	def parseCmdLine(s):
		try: 
			s.optlist,s.args = getopt.getopt(sys.argv[1:], '')
		except getopt.GetoptError:
			s.usage();
		if (len(s.args) < 1):
			s.usage();
		s.host = s.args[0]	
	def usage(s) :
		print "Usage: " + s.testName + " <host>"
		sys.exit(1);
	def setEnv(s):
		path = os.getenv("PATH") + ":" + s.pathTmsControl;
		os.putenv("PATH",path);

	def testEnv(s):
		if (os.access(s.dataFile,os.R_OK) == False):
			print "Test environment fail unable to open test data file (" + s.dataFile +")";
			sys.exit(1);
	def printErr(s,err):
		print "Test failure (" + err + ")"; 
		sys.exit(1);
	def runTest(s,cmd,err):
		print "Run (" + cmd + ")"
		if (os.system(cmd) != 0):
			s.printErr(err);
	def runTestPipe(s,cmd,err):
		print "Run (" + cmd + ")"
		fd = os.popen(cmd)
		ret = fd.readlines()
		if (fd.close() != None):
			s.printErr(err);
		for a in ret:
			print a,
		return ret;
	def merge(s,outfile,infiles,fields):
		# merge specified fields of two files  for viewing
		ret = ""
		out = open(outfile,"w")
		f0 = open(infiles[0]); 
		f1 = open(infiles[1]); 
		s0 = f0.readlines();
		s1 = f1.readlines();
	
#		 Output Field names	
		cols = []
		for i in fields:
			cols.append(s0[0].split().index(i));		# Column of interest
			out.write(i + " " + i + "1 ")
			ret = ret + "-y " + i + " -y " + i + "1 "; 
		out.write("\n");	 
		for i,v in enumerate(s0):
			if (i > 1):
				a = s0[i].split()
				b = s1[i].split()
				for c in cols:
					out.write(a[c] + " " + b[c] + " ")
				out.write("\n");	
		return ret
