/*******************************************************************************
 *	BWidgets.h	BWidgets BEAM QT Widgets
 *	T.Barnaby,	BEAM Ltd,	2009-07-29
 *	Copyright (c) 2022 All Right Reserved, Beam Ltd, https://www.beam.ltd.uk
 *	For license see LICENSE.txt at the root of the beamlib source tree.
 *******************************************************************************
 */
#ifndef BWidgets_H
#define BWidgets_H	1

#include <qframe.h>
#include <qboxlayout.h>
#include <qgroupbox.h>
#include <qevent.h>
#include <BString.h>

// Handle default spacing on QLayout objects
extern int blayoutSpacing;					///< Default internal margins and spacing of layout widgets

inline void blayoutSetSpacing(QLayout& layout, int s){		///< Sets  internal margins and spacing of layout widgets
	layout.setSpacing(s);
	layout.setContentsMargins(s, s, s, s);
}

void setBackgroundColour(QWidget* widget, QColor col);		///< Sets the background colour of a widget

class BHBox : public QFrame {
public:
			BHBox(QWidget* parent);

	QHBoxLayout&	layout();
protected:
	void		childEvent(QChildEvent* event);
private:
	QHBoxLayout	olayout;

};

class BVBox : public QFrame {
public:
			BVBox(QWidget* parent);

	QVBoxLayout&	layout();
protected:
	void		childEvent(QChildEvent* event);
private:
	QVBoxLayout	olayout;

};

class BGrid : public QFrame {
public:
			BGrid(BUInt size, Qt::Orientation orientation, QWidget* parent);

	QGridLayout&	layout();
protected:
	void		childEvent(QChildEvent* event);
private:
	QGridLayout	olayout;
	Qt::Orientation	oorientation;
	BUInt		osize;
	BUInt		orow;
	BUInt		ocolumn;
};

class BGroupBox : public QGroupBox {
public:
			BGroupBox(QString title, BUInt size, Qt::Orientation orientation, QWidget* parent);

	QGridLayout&	layout();
protected:
	void		childEvent(QChildEvent* event);
private:
	QGridLayout	olayout;
	Qt::Orientation	oorientation;
	BUInt		osize;
	BUInt		orow;
	BUInt		ocolumn;
};


#endif
