/*******************************************************************************
 *	BWidgets.cc	BWidgets BEAM QT Widgets
 *	T.Barnaby,	BEAM Ltd,	2009-07-29
 *	Copyright (c) 2022 All Right Reserved, Beam Ltd, https://www.beam.ltd.uk
 *	For license see LICENSE.txt at the root of the beamlib source tree.
 *******************************************************************************
 */
#include <BWidgets.h>

int blayoutSpacing = 2;					// Default spacing of layout widgets

BHBox::BHBox(QWidget* parent) : QFrame(parent), olayout(this){
	blayoutSetSpacing(olayout, blayoutSpacing);
}

QHBoxLayout& BHBox::layout(){
	return olayout;
}

void BHBox::childEvent(QChildEvent* event){
	QWidget::childEvent(event);
	if((event->type() == QEvent::ChildAdded) && event->child()->isWidgetType())
		olayout.addWidget((QWidget*)event->child());
}

BVBox::BVBox(QWidget* parent) : QFrame(parent), olayout(this){
	blayoutSetSpacing(olayout, blayoutSpacing);
}

QVBoxLayout& BVBox::layout(){
	return olayout;
}

void BVBox::childEvent(QChildEvent* event){
	QWidget::childEvent(event);
	if((event->type() == QEvent::ChildAdded) && event->child()->isWidgetType())
		olayout.addWidget((QWidget*)event->child());
}

BGrid::BGrid(BUInt size, Qt::Orientation orientation, QWidget* parent) : QFrame(parent), olayout(this), oorientation(orientation), osize(size){
	orow = 0;
	ocolumn = 0;
	blayoutSetSpacing(olayout, blayoutSpacing);
}

QGridLayout& BGrid::layout(){
	return olayout;
}

void BGrid::childEvent(QChildEvent* event){
	QWidget::childEvent(event);
	if((event->type() == QEvent::ChildAdded) && event->child()->isWidgetType())
		olayout.addWidget((QWidget*)event->child(), orow, ocolumn);

	if(oorientation == Qt::Horizontal){
		if(++ocolumn >= osize){
			ocolumn = 0;
			orow++;
		}
	}
	else {
		if(++orow >= osize){
			orow = 0;
			ocolumn++;
		}
	}
}

BGroupBox::BGroupBox(QString title, BUInt size, Qt::Orientation orientation, QWidget* parent) : QGroupBox(title, parent), olayout(this), oorientation(orientation), osize(size){
	orow = 0;
	ocolumn = 0;
	blayoutSetSpacing(olayout, blayoutSpacing);
	setAlignment(Qt::AlignLeft);
}

QGridLayout& BGroupBox::layout(){
	return olayout;
}

void BGroupBox::childEvent(QChildEvent* event){
	QWidget::childEvent(event);
	if((event->type() == QEvent::ChildAdded) && event->child()->isWidgetType())
		olayout.addWidget((QWidget*)event->child(), orow, ocolumn);

	if(oorientation == Qt::Horizontal){
		if(++ocolumn >= osize){
			ocolumn = 0;
			orow++;
		}
	}
	else {
		if(++orow >= osize){
			orow = 0;
			ocolumn++;
		}
	}
}
