/*******************************************************************************
 *	TmsBlrSim.cc	TMS Blr Simulator
 *			T.Barnaby,	BEAM Ltd,	2007-05-11
 *******************************************************************************
 */

#include <stdio.h>
#include <syslog.h>
#include <unistd.h>
#include <getopt.h>
#include <Blr.h>


void usage(){
	fprintf(stderr, "tmsBlrSim: Version: %s\n", VERSION);
	fprintf(stderr, "Usage: tmsBlrSim [options] <filename>\n");
	fprintf(stderr, "Simuales the Blr locking\n");
	fprintf(stderr, "  -t <type>     - Specifies the signal type (beam1 etc)\n");
}

static struct option options[] = {
		{ "?",			0, NULL, 0 },
		{ "h",			0, NULL, 0 },
		{ "help",		0, NULL, 0 },

		{ "t",			1, NULL, 0 },
		{ 0,0,0,0 }
};

int main(int argc, char** argv){
	BError			err;
	ParamList		params;
	BString			s;
	int			c;
	int			optIndex = 0;
	BString			fileName = "";
	BString			typeName = "";
	double			sampleRate = 125000000;
	double			fref = 437000;
	Blr			blr;
	
	while((c = getopt_long_only(argc, argv, "", options, &optIndex)) == 0){
		s = options[optIndex].name;
		if(s == "help" || s == "h" || s == "?"){
			usage();
			return 1;
		}
		else if(s == "t"){
			typeName = optarg;
		}
	}
	
	if(optind != argc){
		usage();
		return 1;
	}

	params.setValue("sampleRate", sampleRate);
	params.setValue("fref", fref);
	params.setValue("fileName", argv[optind++]);
	
	printf("SampleRate: %f\n", sampleRate);
	printf("FRef: %f\n", fref);
	

	if(err = blr.init(params)){
		fprintf(stderr, "Blr Init Error: %s\n", err.getString().retStr());
		return 1;
	}
	
	if(err = blr.run()){
		fprintf(stderr, "Blr Run Error: %s\n", err.getString().retStr());
		return 1;
	}

	return 0;
}
