/*
* Title:	tmsControlMainGui.cpp 
* Author:	M.Thomas BEAM Ltd
* Date:		2007-02-13
*
* Contents:	Primary interface for Cern TMS system test/debug Gui
*
* Mod Rec:
*
*/

#include <qmenubar.h>
#include <qmessagebox.h>
#include <qlabel.h>
#include <qinputdialog.h>
#include <qimage.h>

#include <tmsControlMainWin.h>
#include <qapplication.h>
#include <Globals.h>
#include <unistd.h>

TmsControlMainWin::TmsControlMainWin(Control& control) : ocontrol(control) {
}

TmsControlMainWin::~TmsControlMainWin(){
}

void TmsControlMainWin::initMenubar(){
	QMenu*		m;

	m = menuBar()->addMenu(tr("File"));
	m->addAction(addAction(tr("New Connection"), tr("&New Connection"), tr("Ctrl+N"), SLOT(slotNewConnection()), tr("Starts a new job")));
	m->addAction(addAction(tr("Quit"), tr("&Quit"), tr("Ctrl+Q"), SLOT(slotQuit()), tr("Quits the application")));
	
	m = menuBar()->addMenu(tr("Options"));
	m->addAction(addAction(tr("Prefferences"), tr("&Prefferences"), tr("Ctrl+P"), SLOT(slotPrefferences()), tr("Setup prefferences")));

	m = menuBar()->addMenu(tr("&Help"));
	m->addAction(addAction(tr("Manual"), tr("&Manual"), tr("Ctrl+M"), SLOT(slotManual()), tr("Online Manual")));
	m->addAction(addAction(tr("TMS Manual"), tr("&TMS Manual"), tr("Ctrl+T"), SLOT(slotTmsManual()), tr("TMS System Manual")));
	m->addAction(addAction(tr("About"), tr("&About"), tr("Ctrl+A"), SLOT(slotAbout()), tr("About the program")));
}

void TmsControlMainWin::initMain(){
	BError		err;
	QFont		f;
	
	BString 	host;

	if (ghostName.len() > 0) {
		host = ghostName;
	}
	else {
		host = gconfig.findValue("DefaultServer:");
	}
	if (host.len() > 0) 
		ocontrol.setHost(host);

	if (err = ocontrol.init()) {				// System defaults to localhost
		BString msg = BString("Attempting to connect to (") + host + "), ring: " + gring;
		warningDialog("Connecting to Server",err,msg);
	}

	otabd     	= new QTabWidget(this);
	
	oconfigureWin 	= new ConfigureWin(this,ocontrol);
	otabd->addTab(oconfigureWin,"Configure System");

	ocontrolDataWin = new ControlDataWin(this,ocontrol);
	otabd->addTab(ocontrolDataWin,"Control/Data View");
	opupeDiagnosticsWin = new PupeDiagnosticsWin(this,ocontrol);
	otabd->addTab(opupeDiagnosticsWin,"Pupe Diagnostics");
	opupeSimulateWin = new PupeSimulateWin(this,ocontrol);
	otabd->addTab(opupeSimulateWin,"Pupe Simulation");
	ophaseTableWin 	= new PhaseTableWin(this,ocontrol);
	otabd->addTab(ophaseTableWin,"Cycle Params");
	
	otestWin 	= new TestWin(this,ocontrol);
	otabd->addTab(otestWin,"Server SelfTest");
	ostatusWin 	= new StatusWin(this,ocontrol);
	otabd->addTab(ostatusWin,"Status");
	ostatisticsWin 	= new StatisticsWin(this,ocontrol);
	otabd->addTab(ostatisticsWin,"Statistics");

	ooptionsWin	= new OptionsWin(this,ocontrol);

	setCentralWidget(otabd);
	otabd->setMinimumSize(1000,900);
	otabd->setTabPosition(QTabWidget::South);
	
	otabd->show();
	oconfigureWin->show();


	f = qApp->font();
	f.setPointSize(10);
	qApp->setFont(f);
	
	gstatusbar = statusBar();
	
}

void	TmsControlMainWin::slotQuit() {
	exit(0);
}

void	TmsControlMainWin::initToolbar() {
}


void	TmsControlMainWin::slotPrefferences() {
	ooptionsWin->show();
}

void	TmsControlMainWin::slotEnterWhatsThis() {
	whatsThis();
}

void	TmsControlMainWin::warningDialog(BString title,BError err,BString msg){
	BString	m;
	
	m = BString("<h5>") + title + "</h5><p>" + msg + "<br>" + err.getString() + "</p>";
	QMessageBox::warning(this, "tmsControlGui - Warning", m.retStr());
}

void	TmsControlMainWin::slotNewConnection() {
	BError	err;
	bool	ok;
	BString	host = ghostName;
	QString	s = host.retStr();
	
//	host = QInputDialog::getText("tsmControlGui", "Enter Host Name:",QLineEdit::Normal,QString::null, &ok, this );
	host = QInputDialog::getText(this, "tsmControlGui", "Enter Host Name:",QLineEdit::Normal, s, &ok);
    	if (ok && (host.len() > 0)) {
		ghostName = host;
		ocontrol.setHost(host);
	}	
	if (err = ocontrol.init()) {
		BString msg = BString("Attempting to conect to (") + host + ")";
		warningDialog("Connecting to Remote",err,msg);
	}
}

void	TmsControlMainWin::configurationChanged() {
}


void TmsControlMainWin::slotAbout() {
	BString		msg;
	QPixmap		logo("alphadata_beam_logo.png");
	QMessageBox	mbox(this);
	
	
	msg = "<p><b>tmsControlGui</b> - Trajectory Measurement System Test Interface</p>";
	msg += BString("<p>&copy; BEAM Ltd 2013</p><p>Version: ") + VERSION + "</p>";

	mbox.setIconPixmap(logo);
	mbox.setWindowTitle("About");
	mbox.setText(msg.retStr());
	mbox.exec();
}

void TmsControlMainWin::slotManual() {
	BIter		i;
	BList<BString>	fnames;
	BString		fname;
	BString		cmd;
	
	fnames.append("/usr/tms/doc/TmsControlGui.pdf");
	fnames.append("./TmsControlGui.pdf");
	fnames.append("../doc/TmsControlGui.pdf");
	fnames.append("../../doc/TmsControlGui.pdf");

	for (fnames.start(i);! fnames.isEnd(i); fnames.next(i)) {
		if (access(fnames[i].retStr(),R_OK) == 0) {
			fname = fnames[i];
			break;
		}	
	}
	if (! fnames.isEnd(i)) {
		cmd =BString("firefox ") + fname + "&";
		system(cmd.retStr());
	}
	else {
		QMessageBox::warning(this, "Warning", "Unable to locate the help files");
	}
}




void TmsControlMainWin::slotTmsManual() {
	BIter		i;
	BList<BString>	fnames;
	BString		fname;
	BString		cmd;
	
	fnames.append("/usr/tms/doc/index.html");
	fnames.append("./index.html");
	fnames.append("../doc/index.html");
	fnames.append("../../doc/index.html");

	for (fnames.start(i);! fnames.isEnd(i); fnames.next(i)) {
		if (access(fnames[i].retStr(),R_OK) == 0) {
			fname = fnames[i];
			break;
		}	
	}
	if (! fnames.isEnd(i)) {
		cmd =BString("firefox ") + fname + "&";
		system(cmd.retStr());
	}
	else {
		QMessageBox::warning(this, "Warning", "Unable to locate the help files");
	}
}





