/*
* Title:	StatisticsWin.h
* Author:	M.Thomas BEAM Ltd
* Date:		2007-02-13
*
* Contents:	Use interface to TMS server Statistics
*
* Mod Rec:
*
*/
#ifndef STATISTICSWIN_H
#define STATISTICSWIN_H

#include <BWidgets.h>
#include <Control.h>
#include <BString.h>
#include <BError.h>
#include <qtextedit.h>
#include <qtimer.h>


// User interface to TMS server Statistics
class StatisticsWin : public BHBox {
        Q_OBJECT
public:
        StatisticsWin(QWidget* w,Control& c);
	~StatisticsWin();

	void	showEvent(QShowEvent* event);
	void	hideEvent(QHideEvent* event);

private slots:
	void	updateTimed();
	void 	updateForced();
private:
	void	getStats();
	void	warningDialog(BString title, BError err);

	Control&		ocontrol;
	QTextEdit*		ostatistics;
	QTimer*			oticker;			
	int			owarningActive;

};
#endif
