/*
* Title:	ConfigureWin.cpp 
* Author:	M.Thomas BEAM Ltd
* Date:		2007-02-13
*
* Contents:	Configuration Data entry and control window
*
* Mod Rec:
*
*/


#include <ConfigureWin.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <TmsD.h>
#include <BFile.h>
#include <qlayout.h>
#include <qmessagebox.h>
#include <Globals.h>
#include <qheaderview.h>

const	int	virtualChannels = 50;
const	int	moduleNumCol = 1;
const	int	pupeNumCol = 2;
const	int	pupeChanCol = 3;


ConfigureWin::ConfigureWin(QWidget* w,Control& c) : BVBox(w), ocontrol(c) {
	BString		s;
	BHBox*		whb;
	QPushButton*	reconfigButton;
	QPushButton*	addButton;
	QPushButton*	delButton;
	QLabel*		label;	
	
	label 		= new QLabel("explanation", this);
	opuParams 	= new BWTableView(this);
	whb		= new BHBox(this);
	
	reconfigButton 	= new QPushButton("Reconfigure",whb);
	addButton 	= new QPushButton("Add Channel",whb);
	delButton 	= new QPushButton("Delete Last Channel",whb);

	s = "<p><b>Mapping of Virtual Channel to Pickups<b></p>";
	s += "<p>Enter the module number, pickup number and pickup channel to be associated with a virtual channel</p>";
	
	label->setText(s.retStr());

	opuParams->setEditable(1);
	opuParams->setColumns(bstringToList("Virtual Channel,Module Number,Pupe Number,Pupe Channel"));
	opuParams->setColumnWidths(bstringToList("125,125,125,125"));
	opuParams->verticalHeader()->hide();

	readConfig();
	connect(reconfigButton,SIGNAL(clicked()),this,SLOT(reconfigure()));
	connect(addButton,SIGNAL(clicked()),this,SLOT(addChannel()));
	connect(delButton,SIGNAL(clicked()),this,SLOT(delChannel()));
	connect(&ocontrol,SIGNAL(newConnection()),this,SLOT(update()));
}
	
ConfigureWin::~ConfigureWin() {}

void	ConfigureWin::update() {
	if (! isVisible())
		return;
	readConfig();
}


void	ConfigureWin::show() {
	update();
	QWidget::show();	
}

void	ConfigureWin::readConfig() {
	BError		err;
	unsigned int	n;
	Tms::ConfigInfo	info;
	QString		s;


	if (err = ocontrol.getConfiguration(info)) {			//Expected if no connection
		return;
	}
	opuParams->setRowCount(info.puReferences.size());
	
	for (n = 0;n < info.puReferences.size();n++) {
		Tms::PuChannel	c;
		BString		moduleNum = info.puReferences[n].moduleNum;
		BString		pupeNum = info.puReferences[n].pupeNum;
		BString		pupeChan = info.puReferences[n].pupeChan;
	
		s.setNum(n + 1);
		opuParams->setText(n,0,s);
		opuParams->setText(n,1,moduleNum.retStr());
		opuParams->setText(n,2,pupeNum.retStr());
		opuParams->setText(n,3,pupeChan.retStr());
	}
}

void ConfigureWin::reconfigure() {
	BError		err;
	int		n;
	Tms::ConfigInfo	config;

	for (n = 0;n < opuParams->rowCount();n++) {
		Tms::PuChannel	c;
		c.moduleNum = opuParams->getText(n,1).retUInt();
		c.pupeNum = opuParams->getText(n,2).retUInt();
		c.pupeChan = opuParams->getText(n,3).retUInt();
		config.puReferences.push_back(c);
	}
	if (err = ocontrol.reconfigure(config)) {
		warningDialog("Channel Configuation",err);
		return;	
	}
	gstatusbar->showMessage("Channels Reconfigured",2000);
}

void	ConfigureWin::addChannel(){
	QString	s;
	int	index;
	
	opuParams->insertRow(opuParams->rowCount());

	s.setNum(opuParams->rowCount());
	
	index = opuParams->rowCount() - 1;
	opuParams->setText(index,0,s);
	opuParams->setText(index,1,"0");
	opuParams->setText(index,2,"0");
	opuParams->setText(index,3,"0");
	opuParams->setCurrentCell(index,1);
}

void	ConfigureWin::delChannel(){
	opuParams->removeRow(opuParams->rowCount() - 1);
}


void	ConfigureWin::warningDialog(BString title, BError err){
	BString	m;
	
	m = BString("<h5>") + title + "</h5><p>" + err.getString() + "</p>";
	QMessageBox::warning(this, "Warning", m.retStr());
}

