/*
* Title:	BGraphControls.cpp
* Author:	M.Thomas BEAM Ltd
* Date:		2007-05-31
*
* Contents:	GUI controls for BGraph object
*
*/



#ifndef BGRAPHCONTROLS_H
#define BGRAPHCONTROLS_H

#include <BGraph.h>
#include <BList.h>
#include <qscrollbar.h>
#include <qpushbutton.h>
#include <qwidget.h>

class	BGraphControlBasic: public BHBox {
        Q_OBJECT
public:
		BGraphControlBasic(QWidget* p);
	void 	addGraph(BGraph* graph);			///< Add Graph to be managed
	void	setMax(double max);

public slots:
	void	scroll(int val);
	void	scroll();
	void	zoomIn();
	void	zoomOut();
	void	updateScrollbar();

private:
	void	zoom(int in);

	BList<BGraph*>		ographs;
	QScrollBar*		oscroll;
	QPushButton*		ozoomIn;
	QPushButton*		ozoomOut;
	double 			omax;
};



#endif
