/***************************************************************************
 *	BGraph.h	Graph plotter
 *			T.Barnaby,	BEAM Ltd,	2007-05-31
 ***************************************************************************
 */
#ifndef	BGraph_H
#define BGraph_H	1

#include <BWidgets.h>
#include <BString.h>
#include <BArray.h>
#include <qtimer.h>
#include <qlabel.h>

class BGraph;
	
class WAxisLabel : public QWidget {
public:
			WAxisLabel(QWidget* parent, Bool yaxis);

	void		setLabel(BString label);
	void		setRange(BFloat min, BFloat max);

protected:
	void		paintEvent(QPaintEvent* event);

private:
	Bool		oyaxis;
	BString		olabel;
	BFloat		omin;
	BFloat		omax;
};


class BGraphPlot : public QWidget {
public:
			BGraphPlot(QWidget* parent);

	void		setGrid(int xStep, int yStep);
	void		setYRange(double min, double max);	///< Sets the YRange, optional
	void		setXRange(double min, double max);	///< Sets the YRange, optional
	void		setData(BArray<float>& data);
	void		getXMinMax(double& min, double& max);

protected:
	void		plotData();
	void		resizeEvent(QResizeEvent* event);
	void		paintEvent(QPaintEvent* event);

private:
	int		oxStep;
	int		oyStep;
	double		oxRangeMin;
	double		oxRangeMax;
	double		oyRangeMin;
	double		oyRangeMax;
	double		oyMinValue;
	double		oxMaxValue;
	double		oxMinValue;
	double		oyMaxValue;
	BArray<float>	odata;			///< The data buffer
	BArray<QPoint>	opoints;
};

class BGraph: public BGrid {
	Q_OBJECT
public:
	enum GainMode		{ AUTO, FIXED };
	
				BGraph(QWidget* parent);
				~BGraph();

	void			setData(BArray<float> data);		///< Set Plot data
	void			getData(BArray<float>& data);		///< Get Plot data

	void			setGrid(int xStep, int yStep);
	void			setXLabel(BString label);
	void			setYLabel(BString label);
	void			setYRange(double min, double max);	///< Sets the YRange, optional
	void			setXRange(double min, double max);	///< Sets the YRange, optional

	void			setYLabelWidth(int width);
	void			getXMinMax(double& min, double& max);

public slots:
	void			clear();		///< Clear the plot and all data

private:
	BArray<float>		odata;			///< The data buffer
	
	WAxisLabel*		oyLabelBox;		///< The Y label widget
	WAxisLabel*		oxLabelBox;		///< The X label widget
	BHBox*			oplotFrame;		///< The frame around the plot
	BGraphPlot*		oplot;			///< The actual plot

	BArray<QPoint>		opoints;		////< Temporary array for polt updates
};

#endif
