/***************************************************************************
 *	AppGui.cpp	Main fronend for application
 *			T.Barnaby,	BEAM Ltd,	27/6/03
 ***************************************************************************
 */
#include <stdlib.h>
#include <AppGui.h>
#include <qstatusbar.h>
#include <qpushbutton.h>
#include <qmenubar.h>
#include <qwhatsthis.h>

AppGui::AppGui(){
}

AppGui::~AppGui(){
}

void AppGui::init(QString title){
	setWindowTitle(title);
	initMenubar();
	initMain();
	initStatus();
	initToolbar();
}

QAction* AppGui::addAction(QString name, QString menuName, QString accelKey, QString memberFunc, QString tip){
	QAction*	a;
	
	a = new QAction(name, this);
	a->setShortcut(QKeySequence(accelKey));
	a->setStatusTip(tip);
	a->setWhatsThis(tip);
	connect(a, SIGNAL(triggered()), this, memberFunc.toLatin1());

	return a;
}

void AppGui::initMenubar(){
	QMenu*		m;

	m = menuBar()->addMenu(tr("File"));
	m->addAction(addAction(tr("Quit"), tr("&Quit"), tr("Ctrl+Q"), SLOT(slotQuit()), tr("Quits the application")));
}


void AppGui::initToolbar() {
	otoolbar = addToolBar("toolbar");
}


void AppGui::initMain(){
	QPushButton*	b;
	
	b = new QPushButton("Default AppGui Running", this);
	setCentralWidget(b);
}


void AppGui::initStatus() {
	statusBar()->showMessage(tr("Ready"));
}

void AppGui::slotQuit(){
	QMainWindow::close();
}
