#!/usr/bin/env python
################################################################################
#	PlotFile.py	Signal plotter
#			T.Barnaby,	BEAM Ltd,	2006-02-10
################################################################################
#

import os
import sys
import time
import getopt

def plotSig(fileName, num, labels, toFile=""):
	cmd="set multiplot; set format x ''; set lmargin 10; set bmargin 0; set tmargin 0; set grid xtics;";
	
	for i in range(0, num):
		o = float(num - i - 1) / num;
		s = float(1) / num;

		if(i == 4):
			cmd = cmd + "set yrange [-500:1000];";
		elif(i == 14):
			cmd = cmd + "set yrange [*:*];";
 		else:
			cmd = cmd + "set yrange [-0.1:1.1];";

		if(labels):
			cmd = cmd + "set ylabel '" + labels[i] + "';";
		if(i == num - 1):
			cmd = cmd + "set format x '%g';";

		cmd = cmd + "set origin 0," + str(o) + "; set size 1," + str(s) + ";"
		cmd = cmd + "plot '" + fileName + "' using " + str(i + 1) + " with lines;"

	cmd = cmd + "unset multiplot; pause 1000;"

#	print cmd

	f = os.popen("gnuplot -", "w");
	f.write(cmd);
	f.flush();

def usage():
	print "Usage: filePlot.py [ -p <file> ] <signal file>";
#	print "		-p <file>	- Create graphics file (.png)"
	
def main():
	toFile		= "";
				
	try:
		opts, args = getopt.getopt(sys.argv[1:], "p:");
	except getopt.GetoptError:
        	# print help information and exit:
        	usage();
        	sys.exit(1);

	for o in opts:
		if(o[0] == "-p"):
			toFile = o[1];
		else:
			usage();

	if(len(args) != 1):
		usage();
		sys.exit(1);

	labels = str("X FrefIn PllMsb PhaseTableMsb Lo1 Sigma Lo2 Gate Blr Mean1 Mean2 RfSelect1 RfSelect2 SelFilter InfoStrobe SwitchState DdsFreq").split();
	plotSig(args[0], 17, labels, toFile);
		
	sys.exit(0);
	
if __name__ == "__main__":
	main();
