/*******************************************************************************
 *	BTimeStampMs.h	TimeStamp classes
 *			T.Barnaby,	BEAM Ltd,	2005-10-20
 *	Copyright (c) 2012 All Right Reserved, Beam Ltd, http://www.beam.ltd.uk
 *******************************************************************************
 */
#ifndef BTimeStampMs_H
#define BTimeStampMs_H	1

#include <stdint.h>
#include <BError.h>

class BTimeStampMs {
public:
			BTimeStampMs(BString str = "");
			~BTimeStampMs();
	
	void		clear();				///< Clear the date/time

	void		setNow();				///< Set the timeStamp to now
	
	BTimeStampMs&	addMilliSeconds(int milliSeconds);	///< Add the given number of milli seconds. This should be less that a year
	BTimeStampMs&	subMilliSeconds(int milliSeconds);	///< Add the given number of milli seconds. This should be less that a year
	BTimeStampMs&	addSeconds(int seconds);		///< Add the given number of seconds. This should be less that a year
	BTimeStampMs&	subSeconds(int seconds);		///< Subtract the given number of seconds. This should be less that a year
	uint32_t	getYearSeconds();			///< Get number of seconds within the year
	uint64_t	getYearMilliSeconds();			///< Get number of seconds within the year

	BString		getString(BString separator = "T");	///< Get the time as an ISO date/time string
	BString		getStringNoMs(BString separator = "T");	///< Get the time as an ISO date/time string with no ms
	BError		setString(BString dateTime);		///< Set the time from an ISO date/time

	BString		getDurationString(BString separator = "T");	///< Get the time as an ISO date/time string but with month's and days starting from 0
	BString		getDurationStringNoMs(BString separator = "T");	///< Get the time as an ISO date/time string but with month's and days starting from 0 with no ms
	BError		setDurationString(BString dateTime);		///< Set the time from an ISO date/time string but with month's and days starting from 0
	BString		getStringRaw();
	
	void		getDate(int& year, int& mon, int& day);	///< Get the year, month and day
	int		compare(const BTimeStampMs& timeStamp);	///< Compare two dates
	
	int		operator>(const BTimeStampMs& timeStamp){ return (compare(timeStamp) > 0); }
	int		operator>=(const BTimeStampMs& timeStamp){ return (compare(timeStamp) >= 0); }
	int		operator<(const BTimeStampMs& timeStamp){ return (compare(timeStamp) < 0); }
	int		operator<=(const BTimeStampMs& timeStamp){ return (compare(timeStamp) <= 0); }
	
	static int	isLeap(int year);
	static BUInt64	difference(BTimeStampMs t2, BTimeStampMs t1);

public:
	uint16_t	year;		///< Year (2000 .. 3000)
	uint16_t	yday;		///< Day in year (0 .. 365)
	uint16_t	hour;		///< Hour (0 .. 23)
	uint16_t	minute;		///< Minute (0 .. 59)
	uint16_t	second;		///< Second (0 .. 59)
	uint16_t	milliSecond;	///< MilliSecond (0 .. 999)
	int32_t		sampleNumber;	///< The sample number this time refers to
private:
};

#endif
