/*******************************************************************************
 *	BObjStringFormat.cpp		Beam Object to/from strings
 *			T.Barnaby,	BEAM Ltd,	2016-09-27
 *******************************************************************************
 *
 * Convert data objects to and from various string formats.
 */
#include	<BObjStringFormat.h>
#include	<BTime.h>
#include	<math.h>


BString toBString(BString n, Bool v){
	return BString::convert(v);
}

BString toBString(BString n, BInt8 v){
	return BString::convert(v);
}

BString toBString(BString n, BUInt8 v){
	return BString::convert(v);
}

BString toBString(BString n, BInt16 v){
	return BString::convert(v);
}

BString toBString(BString n, BUInt16 v){
	return BString::convert(v);
}

BString toBString(BString n, BInt32 v){
	return BString::convert(v);
}

BString toBString(BString n, BUInt32 v){
	return BString::convert(v);
}

BString toBString(BString n, BInt64 v){
	BString	s;
	return s.printf("%lld", v);
}

BString toBString(BString n, BUInt64 v){
	BString	s;
	return s.printf("%lud", v);
}

BString toBString(BString n, BFloat32 v){
	return BString::convert(v, 1);
}

BString toBString(BString n, BFloat64 v){
	return BString::convert(v, 1);
}

BString toBString(BString n, BChar v){
	return BString::convert(v);
}

BString toBString(BString n, const BChar* v){
	return BString(v);
}

BString toBString(BString n, BString v){
	return v;
}

BString toBString(BString n, BError v){
	return BString(v.num()) + ", " + v.getString();
}

BString toBString(BString n, BTime v){
	return v.getString();
}


BString toBString(BString name, const BObjMember* m, const void* obj, BStringList ignoreFields){
	BString			s;
	BUInt			i = 0;

	while(m->type){
		if(!bstringListinList(ignoreFields, m->name)){
			if(i)
				s += ", ";

			if((m->typeComp == BTypeCompArrayFixed) && (m->type == BTypeChar)){
				s += BString((char*)obj + m->dataOffset, m->size);
			}
			else if(m->typeComp == BTypeCompSingle){
				switch(m->type){
				case BTypeBool:		s += toBString(m->name, *(Bool*)((char*)obj + m->dataOffset));     break;
				case BTypeInt8:		s += toBString(m->name, *(BInt8*)((char*)obj + m->dataOffset));    break;
				case BTypeUInt8:	s += toBString(m->name, *(BUInt8*)((char*)obj + m->dataOffset));   break;
				case BTypeInt16:	s += toBString(m->name, *(BInt16*)((char*)obj + m->dataOffset));   break;
				case BTypeUInt16:	s += toBString(m->name, *(BUInt16*)((char*)obj + m->dataOffset));  break;
				case BTypeInt32:	s += toBString(m->name, *(BInt32*)((char*)obj + m->dataOffset));   break;
				case BTypeUInt32:	s += toBString(m->name, *(BUInt32*)((char*)obj + m->dataOffset));  break;
				case BTypeInt64:	s += toBString(m->name, *(BInt64*)((char*)obj + m->dataOffset));	break;
				case BTypeUInt64:	s += toBString(m->name, *(BUInt64*)((char*)obj + m->dataOffset));	break;
				case BTypeFloat32:	s += toBString(m->name, *(BFloat32*)((char*)obj + m->dataOffset)); break;
				case BTypeFloat64:	s += toBString(m->name, *(BFloat64*)((char*)obj + m->dataOffset)); break;
				case BTypeString:	s += toBString(m->name, *(BString*)((char*)obj + m->dataOffset));	break;
				case BTypeError:	s += toBString(m->name, *(BError*)((char*)obj + m->dataOffset));	break;
				case BTypeChar:		s += toBString(m->name, *(BChar*)((char*)obj + m->dataOffset));    break;
				case BTypeTime:		s += toBString(m->name, *(BChar*)((char*)obj + m->dataOffset));    break;
				case BTypeObj:		s += toBString(m->name, *(BObj*)((char*)obj + m->dataOffset));     break;
				default:	break;
				}
			}
			else {
				s +="ERROR";
			}
		}
		m++;
		i++;
	}
	
	return s;	
}

BString toBString(BString n, BObj& obj){
	return toBString(n, obj.getMembers(), &obj);
}


BString toBStringJson(BString n, Bool v){
	if(n.len())
		return BString("\"") + n + "\":" + BString::convert(v);
	else
		return BString::convert(v);
}

BString toBStringJson(BString n, BInt8 v){
	if(n.len())
		return BString("\"") + n + "\":" + BString::convert(v);
	else
		return BString::convert(v);
}

BString toBStringJson(BString n, BUInt8 v){
	if(n.len())
		return BString("\"") + n + "\":" + BString::convert(v);
	else
		return BString::convert(v);
}

BString toBStringJson(BString n, BInt16 v){
	if(n.len())
		return BString("\"") + n + "\":" + BString::convert(v);
	else
		return BString::convert(v);
}

BString toBStringJson(BString n, BUInt16 v){
	if(n.len())
		return BString("\"") + n + "\":" + BString::convert(v);
	else
		return BString::convert(v);
}

BString toBStringJson(BString n, BInt32 v){
	if(n.len())
		return BString("\"") + n + "\":" + BString::convert(v);
	else
		return BString::convert(v);
}

BString toBStringJson(BString n, BUInt32 v){
	if(n.len())
		return BString("\"") + n + "\":" + BString::convert(v);
	else
		return BString::convert(v);
}

BString toBStringJson(BString n, BInt64 v){
	BString	s;

	if(n.len())
		return BString("\"") + n + "\":" + s.printf("%lld", v);
	else
		return s.printf("%lld", v);
}

BString toBStringJson(BString n, BUInt64 v){
	BString	s;

	if(n.len())
		return BString("\"") + n + "\":" + s.printf("%uld", v);
	else
		return s.printf("%uld", v);
}

BString toBStringJson(BString n, BFloat32 v){
	BString	s;
	
	
	if(isnan(v))
		s = "\"NAN\"";
	else if(isinf(v))
		s = "\"INFINITY\"";
	else
		s = BString::convert(v, 1);

	if(n.len())
		return BString("\"") + n + "\":" + s;
	else
		return s;
}

BString toBStringJson(BString n, BFloat64 v){
	BString	s;
	
	if(isnan(v))
		s = "\"NAN\"";
	else if(isinf(v))
		s = "\"INFINITY\"";
	else
		s = BString::convert(v, 1);

	if(n.len())
		return BString("\"") + n + "\":" + s;
	else
		return s;
}

BString toBStringJson(BString n, BChar v){
	if(n.len())
		return BString("\"") + n + "\":\"" + v + "\"";
	else
		return BString("\"") + BString::convert(v) + "\"";
}

BString toBStringJson(BString n, const BChar* v){
	if(n.len())
		return BString("\"") + n + "\":\"" + v + "\"";
	else
		return BString("\"") + BString(v) + "\"";
}

BString toBStringJson(BString n, BString v){
	if(n.len())
		return BString("\"") + n + "\":\"" + v + "\"";
	else
		return BString("\"") + v + "\"";
}

BString toBStringJson(BString n, BError v){
	if(n.len())
		return BString("\"") + n + "\":{\"number\":" + v.num() + ",\"string\":\"" + v.getString() + "\"}";
	else
		return BString("\"") + "\":{\"number\":" + v.num() + ",\"string\":\"" + v.getString() + "\"}";
}

BString toBStringJson(BString n, BTime v){
	if(n.len())
		return BString("\"") + n + "\":\"" + v.getString() + "\"";
	else
		return BString("\"") + v.getString() + "\"";
}

BString toBStringJson(BString n, const BObjMember* m, const void* obj, BStringList ignoreFields){
	BString			s;
	BUInt			i = 0;

	if(n.len())
		s += BString("\"") + n + "\":";

	s += "{ ";
	while(m->type){
		if(!bstringListinList(ignoreFields, m->name)){
			if(i)
				s += ", ";

			if((m->typeComp == BTypeCompArrayFixed) && (m->type == BTypeChar)){
				s += BString("\"") + m->name + "\":\"";
				s += BString((char*)obj + m->dataOffset);
				s += "\"";
			}
			else if(m->typeComp == BTypeCompSingle){
				switch(m->type){
				case BTypeBool:		s += toBStringJson(m->name, *(Bool*)((char*)obj + m->dataOffset));	break;
				case BTypeInt8:		s += toBStringJson(m->name, *(BInt8*)((char*)obj + m->dataOffset));	break;
				case BTypeUInt8:	s += toBStringJson(m->name, *(BUInt8*)((char*)obj + m->dataOffset));	break;
				case BTypeInt16:	s += toBStringJson(m->name, *(BInt16*)((char*)obj + m->dataOffset));	break;
				case BTypeUInt16:	s += toBStringJson(m->name, *(BUInt16*)((char*)obj + m->dataOffset));	break;
				case BTypeInt32:	s += toBStringJson(m->name, *(BInt32*)((char*)obj + m->dataOffset));	break;
				case BTypeUInt32:	s += toBStringJson(m->name, *(BUInt32*)((char*)obj + m->dataOffset));	break;
				case BTypeInt64:	s += toBStringJson(m->name, *(BInt64*)((char*)obj + m->dataOffset));	break;
				case BTypeUInt64:	s += toBStringJson(m->name, *(BUInt64*)((char*)obj + m->dataOffset));	break;
				case BTypeFloat32:	s += toBStringJson(m->name, *(BFloat32*)((char*)obj + m->dataOffset));	break;
				case BTypeFloat64:	s += toBStringJson(m->name, *(BFloat64*)((char*)obj + m->dataOffset));	break;
				case BTypeString:	s += toBStringJson(m->name, *(BString*)((char*)obj + m->dataOffset));	break;
				case BTypeError:	s += toBStringJson(m->name, *(BError*)((char*)obj + m->dataOffset));	break;
				case BTypeChar:		s += toBStringJson(m->name, *(BChar*)((char*)obj + m->dataOffset));	break;
				case BTypeTime:		s += toBStringJson(m->name, *(BTime*)((char*)obj + m->dataOffset));	break;
				case BTypeObj:		s += toBStringJson(m->name, *(BObj*)((char*)obj + m->dataOffset));	break;
				default:	break;
				}
			}
			else {
				s += BString("\"") + m->name + "\":\"ERROR\"";
			}
		}
		m++;
		i++;
	}
	
	s += "}";
	return s;	
}

BString toBStringJson(BString n, BObj& obj){
	return toBStringJson(n, obj.getMembers(), &obj);
}

// Very basic JSON string to BDictString
BError toBDictStringFromJson(BString json, BDictString& ds){
	BError		err;
	BString		sp = json.removeSeparators("{} \t");
	BString		s;
	
	while((s = sp.pullToken(",").removeSeparators(" \t")) != ""){
		ds[s.pullToken(":").removeSeparators(" \t\"")] = s.removeSeparators(" \t\"");
	}

	return err;
}
