/*******************************************************************************
 *	BMysql.h	BDS Database Access Object
 *			T.Barnaby,	BEAM Ltd,	2008-05-20
 *	Copyright (c) 2012 All Right Reserved, Beam Ltd, http://www.beam.ltd.uk
 *******************************************************************************
 */
#ifndef BMysql_H
#define BMysql_H	1

#include <BTypes.h>
#include <BError.h>
#include <BDict.h>
#include <BMutex.h>
#include <mysql/mysql.h>

class BMysql {
public:
			BMysql();
			~BMysql();
	
	BError		open(BString hostName, BString dataBase, BString userName, BString password);
	void		close();
	
	BError		get(BString table, BString where, BDictString& fields);
	BError		insert(BString table, BDictString fields, BUInt32* id = 0);
	BError		update(BString table, BUInt32 id, BDictString fields);
	BError		del(BString table, BUInt32 id);					///< Delete record from table
	BError		flush();							///< Flush all data to disk

	BString		escapeString(BString str);					///< Escapes special characters in the string
	
	// Low level routines
	BError		query(BString cmd, BList<BDictString>& result);
	MYSQL&		db();
	void		setDebug(int debug);
private:
	MYSQL		odb;
	int		oopened;
	int		odebug;
	BMutex		olock;
//	static BMutex	olock;		// All BMysql instances share this
};

#endif
