/*******************************************************************************
 *	BFileCsv.cpp	BEAM CSV access class
 *			T.Barnaby,	BEAM Ltd,	2012-01-10
 *******************************************************************************
 */
#include	<BFileCsv.h>
#include	<errno.h>

BFileCsv::BFileCsv(char separator) : oseparator(separator){
}

BError	BFileCsv::readCsv(BStringList& csvList){
	BError	err;
	int	r;
	BString	line;
	
	if((r = readString(line)) <= 0){
		if(r == 0)
			return err.set(ErrorEndOfFile, "End of file");
		else
			return err.set(-errno, strerror(errno));
	}
	
	line.removeNL();
	csvList = line.split(oseparator);
	
	return err;
}

BError	BFileCsv::writeCsv(BStringList& csvList){
	BError	err;
	BString	str;
	
	BListLoop(csvList, i){
		if(str.len())
			str = str + oseparator;
		str += csvList[i];
	}

	if(writeString(str + "\n") < 0)
		err.set(-errno, strerror(errno));

	return err;	
}

