/*******************************************************************************
 *	BEndian.cpp	Byte bswap_p fubctions
 *			T.Barnaby,	BEAM Ltd,	2009-12-18
 *******************************************************************************
 */
#include <BEndian.h>
#include <memory.h>

void bswap_copy(int swap, const void* src, void* dst, BUInt32 nBytes, const char* swapType){
	if(swap){
		char*	d = (char*)dst;
		char*	s = (char*)src;

	//	printf("BBufferStore::copyWithSwap: BIG_ENDIAN: swapType: %s\n", swapType);
		if(swapType[1] == '\0'){	void		updateLen();

			switch(swapType[0]){
			case '8':
				while(nBytes){
					bswap_p64(s, d);
					d += 8;
					s += 8;
					nBytes -= 8;
				}
				break;

			case '4':
				while(nBytes){
					bswap_p32(s, d);
					d += 4;
					s += 4;
					nBytes -= 4;
				}
				break;

			case '2':
				while(nBytes){
					bswap_p16(s, d);
					d += 2;
					s += 2;
					nBytes -= 2;
				}
				break;

			case '1':
			default:
				memcpy(dst, src, nBytes);
				break;
			}
		}
		else {
			const char*	t = swapType;
			const char*	s = (const char*)src;
			char*		d = (char*)dst;
			int		l = 0;

			while(nBytes){
				switch(*t){
				case '8':	bswap_p64(s, d);	l = 8;	break;
				case '4':	bswap_p32(s, d);	l = 4;	break;
				case '2':	bswap_p16(s, d);	l = 2;	break;
				case '1':	bswap_p8(s, d);		l = 1;	break;
				default:	bswap_p8(s, d);		l = 1;	break;
				}

				d += l;
				s += l;
				nBytes -= l;
				t++;
				if(*t == '\0')
					t = swapType;
			}
		}
	}
	else {
		memcpy(dst, src, nBytes);
	}
}
