/*******************************************************************************
 *	BDuration.h	A time duration class
 *			T.Barnaby,	BEAM Ltd,	2010-02-11
 *	Copyright (c) 2012 All Right Reserved, Beam Ltd, http://www.beam.ltd.uk
 *******************************************************************************
 */
#ifndef BDuration_H
#define BDuration_H	1

#include <stdint.h>
#include <BError.h>

class BDuration {
public:
			BDuration(int hour = 0, int minute = 0, int second = 0, int microsecond = 0);
			BDuration(BString str);
			~BDuration();
	
	void		clear();				///< Clear the duration

	void		set(int hour = 0, int minute = 0, int second = 0, int microsecond = 0);

	void		addMilliSeconds(int64_t milliSeconds);	///< Add the given number of milli seconds.
	void		addMicroSeconds(int64_t microSeconds);	///< Add the given number of micro seconds.
	void		addSeconds(int seconds);		///< Add the given number of seconds.
	uint32_t	getSeconds();				///< Get number of seconds
	uint64_t	getMicroSeconds();			///< Get number of micro seconds

	int		hour();
	int		minute();
	int		second();
	int		microSecond();
	
	BString		getString();				///< Get the time as an ISO date/time string
	BError		setString(BString time);		///< Set the time from an ISO date/time

private:
	uint8_t		ohour;		///< Hour (0 .. 23)
	uint8_t		ominute;	///< Minute (0 .. 59)
	uint8_t		osecond;	///< Second (0 .. 59)
	uint8_t		ospare;		///< Padding
	uint32_t	omicroSecond;	///< MicroSecond (0 .. 999999)

};

#endif
