/*******************************************************************************
 *	BDuration.h	TimeStamp classes
 *			T.Barnaby,	BEAM Ltd,	2010-02-11
 *******************************************************************************
 */
#include <BDuration.h>
#include <sys/time.h>


BDuration::BDuration(int hour, int minute, int second, int microSecond){
	set(hour, minute, second, microSecond);
}

BDuration::BDuration(BString str){
	if(str == "")
		clear();
	else
		setString(str);
}

BDuration::~BDuration(){
}

void BDuration::clear(){
	set(0, 0, 0, 0);
}

void BDuration::set(int hour, int minute, int second, int microSecond){
	ohour = hour;
	ominute = minute;
	osecond = second;
	omicroSecond = microSecond;
	ospare = 0;
}

int BDuration::hour(){
	return ohour;
}

int BDuration::minute(){
	return ominute;
}

int BDuration::second(){
	return osecond;
}

int BDuration::microSecond(){
	return omicroSecond;
}

BString BDuration::getString(){
	BString		s;
	
	s.printf("%02d:%02d:%02d.%06d", ohour, ominute, osecond, omicroSecond);

	return s;
}

BError BDuration::setString(BString time){
	BError		err;
	int		h = 0;
	int		m = 0;
	int		s = 0;
	int		ms = 0;
	int		n;

	clear();

	n = sscanf(time, "%02u:%02u:%02u.%06u", &h, &m, &s, &ms);
	if((n != 3) && (n != 4)){
		err.set(ErrorMisc, "Time format error\n");

	}
	else {
		ohour = h;
		ominute = m;
		osecond = s;
		omicroSecond = ms;
	}

	return err;
}

void BDuration::addMicroSeconds(int64_t microSeconds){
	addSeconds(microSeconds / 1000000);
	omicroSecond += microSeconds % 1000000;
	if(omicroSecond >= 1000000){
		if(microSeconds < 0){
			omicroSecond += 1000000;
			addSeconds(-1);
		}
		else {
			omicroSecond -= 1000000;
			addSeconds(1);
		}
	}
}

void BDuration::addMilliSeconds(int64_t milliSeconds){
	addSeconds(milliSeconds / 1000);
	omicroSecond += (1000 * (milliSeconds % 1000));
	if(omicroSecond >= 1000000){
		if(milliSeconds < 0){
			omicroSecond += 1000000;
			addSeconds(-1);
		}
		else {
			omicroSecond -= 1000000;
			addSeconds(1);
		}
	}
}

void BDuration::addSeconds(int seconds){
	if(seconds >= 0){
		osecond += seconds % 60;
		if(osecond >= 60){
			ominute++;
			osecond -= 60;
		}

		ominute += (seconds / 60) % 60;
		if(ominute >= 60){
			ohour++;
			ominute -= 60;
		}

		ohour += (seconds / (60 * 60)) % 24;
		if(ohour >= 24){
			ohour -= 24;
		}
	}
	else {
		seconds = -seconds;
		osecond -= seconds % 60;
		if(osecond >= 60){
			ominute--;
			osecond += 60;
		}

		ominute -= (seconds / 60) % 60;
		if(ominute >= 60){
			ohour--;
			ominute += 60;
		}

		ohour -= (seconds / (60 * 60)) % 24;
		if(ohour >= 24){
			ohour += 24;
		}
	}
}

uint32_t BDuration::getSeconds(){
	uint32_t	s = 0;
	
	s += osecond;
	s += (60 * ominute);
	s += (60 * 60 * ohour);

	return s;
}

uint64_t BDuration::getMicroSeconds(){
	uint64_t	t = 0;
	
	t += omicroSecond;
	t += (1000000ULL * osecond);
	t += (1000000ULL * 60 * ominute);
	t += (1000000ULL * 60 * 60 * ohour);

	return t;
}
