/*******************************************************************************
 *	BDictMap.h	BEAM Dictionary class
 *			T.Barnaby,	BEAM Ltd,	2008-05-21
 *	Copyright (c) 2012 All Right Reserved, Beam Ltd, http://www.beam.ltd.uk
 *******************************************************************************
 */
#ifndef BDictMap_H
#define BDictMap_H	1

#include <BString.h>
#include <map>

/// Template based Array class.
/// This is based on the Standard C++ library map class and has all of the
/// functionality of that class.
template <typename Value> class BDictMap : private std::map<BString, Value> {
public:
	typedef typename BDictMap<Value>::iterator	iterator;
	
	void		clear()			{ std::map<BString, Value>::clear();	}
	int		hasKey(const BString& k){ return std::map<BString, Value>::count(k);	}
	BString		key(iterator& i)	{ return i->first; }
	unsigned int	size()			{ return std::map<BString, Value>::size(); }
	void		start(iterator& i)	{ i = std::map<BString, Value>::begin();	}
	int		isEnd(iterator& i)	{ return(i == std::map<BString, Value>::end());	}
	void		next(iterator& i)	{ ++i;	}
	void		del(const iterator& i)	{ std::map<BString, Value>::erase(i); }
	void		del(const BString& k)	{ std::map<BString, Value>::erase(k); }
	Value&		operator[](iterator& i)	{ return i->second; }
	Value&		operator[](const BString& i)	{ return std::map<BString,Value>::operator[](i); }
private:
};

typedef BDictMap<BString>	BDictMapString;

#endif
