/*******************************************************************************
 *	BDate.h		Date class
 *			T.Barnaby,	BEAM Ltd,	2009-08-14
 *	Copyright (c) 2012 All Right Reserved, Beam Ltd, http://www.beam.ltd.uk
 *******************************************************************************
 */
#ifndef BDate_H
#define BDate_H	1

#include <stdint.h>
#include <BError.h>

class BDateMs;

class BDate {
public:
			BDate(int year = 0, int month = 1, int day = 1);
			BDate(BString str);
			~BDate();
	
	void		clear();				///< Clear the date/time
	void		setFirst();				///< Set the first date available
	void		setLast();				///< Set the last date available

	void		set(time_t time);			///< Set time using Unix time (seconds from 1970-01-01)
	void		set(int year = 0, int month = 1, int day = 1);
	void		setYDay(int year = 0, int yday = 0);
	void		setNow();				///< Set the timeStamp to now

	int		year();
	int		yday();
	int		month();
	int		day();
	
	void		getDate(int& year, int& mon, int& day);

	BString		getString();				///< Get the time as an ISO date/time string
	BString		getStringFormatted(BString format);	///< Gets the time in a string form as per the format. Format syntax as per strftime()
	BError		setString(BString str);			///< Set the time from an ISO date/time
	
	int		isSet(){ return oyear != 0; }
	int		compare(const BDate& date) const;	///< Compare two dates

			operator BString(){ return getString(); }

	int		operator==(const BDate& date) const { return (compare(date) == 0); }
	int		operator!=(const BDate& date) const { return (compare(date) != 0); }
	int		operator>(const BDate& date) const { return (compare(date) > 0); }
	int		operator>=(const BDate& date) const { return (compare(date) >= 0); }
	int		operator<(const BDate& date) const { return (compare(date) < 0); }
	int		operator<=(const BDate& date) const { return (compare(date) <= 0); }

	static int	isLeap(int year);
	static int	daysInMonth(int year, int month);

public:
	uint16_t	oyear;		///< Year (0 .. 65535)
	uint16_t	oyday;		///< Day in year (0 .. 365)
};

// String conversion functions
void toBString(BDate& v, BString& s);
void fromBString(BString& s, BDate& v);

#endif
