/*******************************************************************************
 *	BConfig.cpp	BConfig File Access
 *			T.Barnaby,	BEAM Ltd,	2009-01-28
 *******************************************************************************
 */
#include <BConfig.h>
#include <string.h>

BError BConfig::open(BString fileName, BString mode){
	close();
	ofileName = fileName;
	return ofile.open(fileName, mode);
}

void BConfig::close(){
	ofile.close();
}


BError BConfig::read(){
	BError	err;
	char	buf[10240];
	char	name[10240];
	char*	t;
	char*	f;

	olock.lock();
	clear();
	ofile.seek(0);

	while(ofile.fgets(buf, sizeof(buf))){
		if(strlen(buf)){
			if((buf[0] != '#') && (buf[0] != '\n') && (buf[0] != '\r')){
				buf[strlen(buf) - 1] = '\0';
				if((strlen(buf) > 0) && (buf[strlen(buf) - 1] == '\r'))
					buf[strlen(buf) - 1] = '\0';
				
				for(t = name, f = buf; (*f && !isspace(*f)); t++, f++){
					*t = *f;
				}
				*t = 0;
				while(*f && isspace(*f))
					f++;
				t = f;
				while(*t)
					t++;
				*t = 0;

				operator[](name) = f;
			}
		}
	}
	olock.unlock();

	return err;
}

BError BConfig::write(){
	BError	err;
	BIter	i;
	
	olock.lock();
	ofile.seek(0);
	ofile.truncate();

	for(start(i); !isEnd(i); next(i)){
		ofile.printf("%-15s\t%s\n", key(i).retStr(), operator[](i).retStr());
	}
	ofile.flush();

	olock.unlock();

	return err;
}

BString BConfig::findValue(BString name){
	return operator[](name);
}


BString BConfig::fileName(){
	return ofileName;
}
