/*******************************************************************************
 *	GenBoapMcComms.cc	Boap output
 *			T.Barnaby,	BEAM Ltd,	2/5/03
 *******************************************************************************
 */
#define	DEBUG	1

#include <stdio.h>
#include <stdarg.h>
#include <strings.h>
#include <GenBoapMcComms.h>
#include <bidl.h>

void GenBoapMcComms::produceInt(Node* n, int serve){
	BIter		i;
	BString		s;
	BString		sa;
	BString		c;
	BList<Node*>*	nl;

	switch(n->nodeType()){
	case Node::TMODULE:
		omodule = n->name();
		ofileInt.writeLine(BString("namespace ") + omodule + " {\n");
		ofileInt.indentMore();

		for(n->nodes().start(i); !n->nodes().isEnd(i); n->nodes().next(i)){
			produceInt(n->nodes()[i], serve);
		}
		ofileInt.indentLess();
		ofileInt.writeLine("}\n");
		break;
	case Node::TINTERFACE:
	case Node::TBIDIRECTIONAL:
		ointerface = n->name();
		// Client
		ofileInt.writeLine(BString("class ") + ointerface + " : public BoapMcComms {\n");
		ofileInt.writeLine("public:\n");
		ofileInt.indentMore();
		ofileInt.writeLine(BString("\t") + ointerface + "(Bool threaded = 0, BUInt reqSize = 4);\n");

		ofileInt.writeLine("\n");
		ofileInt.writeLine("// Client interface\n");
		for(n->nodes().start(i); !n->nodes().isEnd(i); n->nodes().next(i)){
			produceInt(n->nodes()[i], 0);
		}

		ofileInt.writeLine("\n");
		ofileInt.writeLine("// Server interface\n");
		ofileInt.writeLine(BString("BError\tprocessPacket(BoapMcPacket& rx, BoapMcPacket& tx);\n\n"));
		for(n->nodes().start(i); !n->nodes().isEnd(i); n->nodes().next(i)){
			produceInt(n->nodes()[i], 1);
		}
		ofileInt.indentLess();
		ofileInt.writeLine("private:\n");
		ofileInt.writeLine("};\n");
		break;
	case Node::TLIST:
		for(n->nodes().start(i); !n->nodes().isEnd(i); n->nodes().next(i)){
			produceInt(n->nodes()[i], serve);
		}
		break;
	case Node::TFUNC:
		if(serve){
			s = "virtual ";
			if(getTypeName(n->node(0)) == "oneway"){
				s = s + "void ";
			}
			else {
				s = s + getTypeName(n->node(0)) + " ";
			}
			s = s + n->name() + "Serve(";

			if(ooptions.hasKey("connectionClass")){
				sa = sa + ooptions["connectionClass"] + "* conn";
			}
			
			nl = &n->node(1)->nodes();
			for(nl->start(i); !nl->isEnd(i); nl->next(i)){
				if(sa.len())
					sa = sa + ", ";
				if(nl->get(i)->node(0)->name() == "in"){
					sa = sa + getTypeName(nl->get(i)->node(1)) + "& ";
				}
				else if(nl->get(i)->node(0)->name() == "inref"){
					sa = sa + "const " + getTypeName(nl->get(i)->node(1)) + "& ";
				}
				else {
					sa = sa + getTypeName(nl->get(i)->node(1)) + "& ";
				}

				sa = sa + nl->get(i)->node(2)->name();
			}
			s = s + sa + ");\n";
			ofileInt.writeLine(s);
		}
		else {
			if(getTypeName(n->node(0)) == "oneway"){
				s = s + "void ";
			}
			else {
				s = s + getTypeName(n->node(0)) + " ";
			}
			s = s + n->name() + "(";
			nl = &n->node(1)->nodes();
			for(nl->start(i); !nl->isEnd(i); nl->next(i)){
				if(i != nl->begin())
					s = s + ", ";
				if(nl->get(i)->node(0)->name() == "in"){
	//				s = s + getTypeName(nl->get(i)->node(1)) + " ";
					s = s + "const " + getTypeName(nl->get(i)->node(1)) + "& ";
				}
				else if(nl->get(i)->node(0)->name() == "inref"){
					s = s + "const " + getTypeName(nl->get(i)->node(1)) + "& ";
				}
				else {
					s = s + getTypeName(nl->get(i)->node(1)) + "& ";
				}
				s = s + nl->get(i)->node(2)->name();
			}
			s = s + ");";
			if(n->node(2) && n->node(2)->nodeType() == Node::TCOMMENT)
				s = s + "\t//" + n->node(2)->name();
			ofileInt.writeLine(s + "\n");
		}
		break;
	case Node::TCOMMENT:
		s = BString("//") + n->name() + "\n";
		ofileInt.writeLine(s);
		break;
	case Node::TAPIVERSION:
		oapiVersion = n->name().retInt();
		break;
	default:
		break;
	}
}

void GenBoapMcComms::produceFuncC(Node* n){
	BIter		i;
	BString		s;
	BList<Node*>*	nl;
	BString		retType;
	
	retType = getTypeName(n->node(0));
	
	ofileImp.writeLine("BMutexLock	lock(olockCall, 1);\n");
	ofileImp.writeLine("char*		txData = opacketTx.data;\n");
	ofileImp.writeLine("char*		rxData = opacketRx.data;\n");
	ofileImp.writeLine("BError		err;\n");
	ofileImp.writeLine("\n");

	ofileImp.writeLine(BString("opacketTx.head.length = sizeof(opacketTx.head);\n"));
	ofileImp.writeLine(BString("opacketTx.head.cmd = ") + ofuncNum + ";\n");
	ofileImp.writeLine("// Push arguments\n");
	
	nl = &n->node(1)->nodes();
	for(nl->start(i); !nl->isEnd(i); nl->next(i)){
		if((nl->get(i)->node(0)->name() == "in") || (nl->get(i)->node(0)->name() == "inout")){
			ofileImp.writeLine(BString("memcpy(txData, &") + nl->get(i)->node(2)->name() + ", sizeof(" + nl->get(i)->node(2)->name() + ")); txData += sizeof(" + nl->get(i)->node(2)->name() + "); opacketTx.head.length += sizeof("  + nl->get(i)->node(2)->name() + ");\n");
		}
	}

	if(retType == "oneway"){
		ofileImp.writeLine("performSend();\n");
	}
	else {
		ofileImp.writeLine("if(err = performCall()){\n");
		ofileImp.indentMore();
		if(retType == "BError")
			ofileImp.writeLine("return err;\n");

		ofileImp.indentLess();
		ofileImp.writeLine("}\n");

		ofileImp.writeLine("// Pop arguments\n");
		nl = &n->node(1)->nodes();
		for(nl->start(i); !nl->isEnd(i); nl->next(i)){
			if((nl->get(i)->node(0)->name() == "out") || (nl->get(i)->node(0)->name() == "inout"))
				ofileImp.writeLine(BString("memcpy(&") + nl->get(i)->node(2)->name() + ", rxData, sizeof(" + nl->get(i)->node(2)->name() + ")); rxData += sizeof(" + nl->get(i)->node(2)->name() + ");\n");
		}
		ofileImp.writeLine("err.set(opacketRx.head.error);\n");

		ofileImp.writeLine("return err;\n");
	}
}

void GenBoapMcComms::produceFuncSwitch(Node* n){
	BString		s;
	BIter		i;
	BList<Node*>*	nl;
	BString		typeName;
	int		a;

	switch(n->nodeType()){
	case Node::TLIST:
		for(n->nodes().start(i); !n->nodes().isEnd(i); n->nodes().next(i)){
			produceFuncSwitch(n->nodes()[i]);
		}
		break;
	case Node::TFUNC:
		ofileImp.writeLine(BString("case ") + ofuncNum + ": {\n");
		ofileImp.indentMore();

		// Do args
		nl = &n->node(1)->nodes();
		for(nl->start(i), a = 0; !nl->isEnd(i); nl->next(i), a++){
			typeName = getTypeName(nl->get(i)->node(1));
			if((nl->get(i)->node(0)->name() == "in") || (nl->get(i)->node(0)->name() == "inout")){
				s = typeName + "&\targ" + a + " = (" + typeName + "&)*rxData; rxData += sizeof(" + typeName + ");\n";
			}
			else {
				s = typeName + "&\targ" + a + " = (" + typeName + "&)*txData; txData += sizeof(" + typeName + ");\n";
			}
			ofileImp.writeLine(s);
		}

		// Call function
		for(nl->start(i), a = 0, s = ""; !nl->isEnd(i); nl->next(i), a++){
			if(s.len())
				s += ", ";
			s = s + "arg" + a;
		}
		if(getTypeName(n->node(0)) == "oneway"){
			ofileImp.writeLine(n->name() + "Serve(" + s + ");\n");
			ofileImp.writeLine("oneway = 1;\n");
		}
		else {		
			ofileImp.writeLine(BString("err = " ) + n->name() + "Serve(" + s + ");\n");
		}
		ofileImp.writeLine("break;\n");
		ofileImp.writeLine("}\n");
		ofileImp.indentLess();
		ofuncNum++;
		break;
	case Node::TAPICMD:
		ofuncNum = n->name().retInt();
		break;
	default:
		break;
	}
}

void GenBoapMcComms::produceFuncServe(Node* n){
	BString		s;
	BIter		i;
	BList<Node*>*	nl;
	BString		typeName;
	int		a;

	switch(n->nodeType()){
	case Node::TLIST:
		for(n->nodes().start(i); !n->nodes().isEnd(i); n->nodes().next(i)){
			produceFuncServe(n->nodes()[i]);
		}
		break;
	case Node::TFUNC:
		if(getTypeName(n->node(0)) == "oneway"){
			s = s + "void ";
		}
		else {
			s = s + getTypeName(n->node(0)) + " ";
		}
		s = s + ointerface + "::" + n->name() + "Serve(";
		nl = &n->node(1)->nodes();
		for(nl->start(i); !nl->isEnd(i); nl->next(i)){
			if(i != nl->begin())
				s = s + ", ";
			if(nl->get(i)->node(0)->name() == "in"){
//				s = s + getTypeName(nl->get(i)->node(1)) + " ";
				s = s + getTypeName(nl->get(i)->node(1)) + "& ";
			}
			else if(nl->get(i)->node(0)->name() == "inref"){
				s = s + "const " + getTypeName(nl->get(i)->node(1)) + "& ";
			}
			else {
				s = s + getTypeName(nl->get(i)->node(1)) + "& ";
			}

			s = s + nl->get(i)->node(2)->name();
		}
		s = s + "){\n";
		ofileImp.writeLine(s);
		ofileImp.indentMore();
		if(getTypeName(n->node(0)) != "oneway"){
			ofileImp.writeLine(getTypeName(n->node(0)) + "\tret;\n");
			ofileImp.writeLine("return ret;\n");
		}
		ofileImp.indentLess();
		ofileImp.writeLine("}\n\n");
		break;

	default:
		break;
	}
}


void GenBoapMcComms::produceImp(Node* n, int serve){
	BString		s;
	BIter		i;
	BList<Node*>*	nl;

	switch(n->nodeType()){
	case Node::TMODULE:
		omodule = n->name();
		ofileImp.writeLine(BString("namespace ") + omodule + " {\n");
		ofileImp.indentMore();
		
		for(n->nodes().start(i); !n->nodes().isEnd(i); n->nodes().next(i)){
			produceImp(n->nodes()[i], 0);
		}
		ofileImp.indentLess();
		ofileImp.writeLine("}\n");
		break;
	case Node::TINTERFACE:
	case Node::TBIDIRECTIONAL:
		ointerface = n->name();
		ofuncNum = 1;
		ofileImp.writeLine(ointerface + "::" + ointerface + "(Bool threaded, BUInt reqSize) : BoapMcComms(threaded, reqSize){\n");
		ofileImp.indentMore();
		ofileImp.writeLine(BString("oapiVersion = ") + oapiVersion + ";\n");
		ofileImp.indentLess();
		ofileImp.writeLine("}\n");

		ofileImp.writeLine("\n");
		ofileImp.writeLine("// Client functions\n");
		for(n->nodes().start(i); !n->nodes().isEnd(i); n->nodes().next(i)){
			produceImp(n->nodes()[i], 0);
		}

		// Serve functions
		ofuncNum = 1;
		ofileImp.writeLine("\n");
		ofileImp.writeLine("// Serve switch\n");

		ofileImp.writeLine(BString("BError\t") + ointerface + "::processPacket(BoapMcPacket& rx, BoapMcPacket& tx){\n");
		ofileImp.indentMore();
		ofileImp.writeLine("char*	rxData = rx.data;\n");
		ofileImp.writeLine("char*	txData = tx.data;\n");
		ofileImp.writeLine("bool	oneway = 0;\n");
		ofileImp.writeLine("BError	err;\n\n");
		ofileImp.writeLine("switch(rx.head.cmd){\n");
		for(n->nodes().start(i); !n->nodes().isEnd(i); n->nodes().next(i)){
			produceFuncSwitch(n->nodes()[i]);
		}
		ofileImp.writeLine("}\n");
		ofileImp.writeLine("if(oneway){\n");
		ofileImp.indentMore();
		ofileImp.writeLine("tx.head.length = 0;\n");
		ofileImp.indentLess();
		ofileImp.writeLine("}\n");
		ofileImp.writeLine("else {\n");
		ofileImp.indentMore();
		ofileImp.writeLine("tx.head.length = sizeof(tx.head) + BUInt(txData - tx.data);\n");
		ofileImp.writeLine("tx.head.cmd = rx.head.cmd | BoapMcTypeReply;\n");
		ofileImp.writeLine("tx.head.error = err.num();\n");
		ofileImp.writeLine("tx.head.addressFrom = oaddressFrom;\n");
		ofileImp.writeLine("tx.head.addressTo = rx.head.addressFrom;\n");
		ofileImp.indentLess();
		ofileImp.writeLine("}\n");
		ofileImp.writeLine("return err;\n");
		ofileImp.indentLess();
		ofileImp.writeLine("}\n");

		ofileImp.writeLine("\n");
		ofileImp.writeLine("// Serve dummy functions\n");
		for(n->nodes().start(i); !n->nodes().isEnd(i); n->nodes().next(i)){
			produceFuncServe(n->nodes()[i]);
		}

		break;

	case Node::TLIST:
		for(n->nodes().start(i); !n->nodes().isEnd(i); n->nodes().next(i)){
			produceImp(n->nodes()[i], 0);
		}
		break;
	case Node::TFUNC:
		if(getTypeName(n->node(0)) == "oneway"){
			s = s + "void ";
		}
		else {
			s = s + getTypeName(n->node(0)) + " ";
		}
		s = s + ointerface + "::" + n->name() + "(";
		nl = &n->node(1)->nodes();
		for(nl->start(i); !nl->isEnd(i); nl->next(i)){
			if(i != nl->begin())
				s = s + ", ";
			if(nl->get(i)->node(0)->name() == "in"){
//				s = s + getTypeName(nl->get(i)->node(1)) + " ";
				s = s + "const " + getTypeName(nl->get(i)->node(1)) + "& ";
			}
			else if(nl->get(i)->node(0)->name() == "inref"){
				s = s + "const " + getTypeName(nl->get(i)->node(1)) + "& ";
			}
			else {
				s = s + getTypeName(nl->get(i)->node(1)) + "& ";
			}

			s = s + nl->get(i)->node(2)->name();
		}
		s = s + "){\n";
		ofileImp.writeLine(s);
		ofileImp.indentMore();
		produceFuncC(n);
		ofileImp.indentLess();
		ofileImp.writeLine("}\n\n");

		ofuncNum++;
		break;
	case Node::TAPIVERSION:
		oapiVersion = n->name().retInt();
		break;
	case Node::TAPICMD:
		ofuncNum = n->name().retInt();
		break;
	default:
		break;
	}
}

BError GenBoapMcComms::produceHeaderInt(){
	BError	err;
	BString	fileName = ofileName + "B.h";
	BString	fileNameDef = ofileName + "B_H";

	ofileInt.printf("/*******************************************************************************\n");
	ofileInt.printf(" *\t%s\tProduced by Bidl\n", fileName.retStr());
	ofileInt.printf(" *******************************************************************************\n");
	ofileInt.printf(" */\n");
	ofileInt.printf("\n");
	ofileInt.printf("#ifndef %s\n", fileNameDef.retStr());
	ofileInt.printf("#define %s 1\n\n", fileNameDef.retStr());

	ofileInt.printf("#include <BTypes.h>\n");
	ofileInt.printf("#include <BComplex.h>\n");
	ofileInt.printf("#include <BoapMc.h>\n");
	ofileInt.printf("#include <%sD.h>\n\n", ofileName.retStr());
	ofileInt.printf("\n");
	return err;
}


BError GenBoapMcComms::produceTrailerInt(){
	BError	err;
	
	ofileInt.printf("#endif\n");
	return err;
}

BError GenBoapMcComms::produceHeaderImp(){
	BError	err;

	ofileImp.printf("/*******************************************************************************\n");
	ofileImp.printf(" *\t%s\tProduced by Bidl\n", (ofileName + ".cc").retStr());
	ofileImp.printf(" *******************************************************************************\n");
	ofileImp.printf(" */\n");
	ofileImp.printf("\n");
	ofileImp.printf("#include <%s>\n", (ofileName + "B.h").retStr());
	ofileImp.printf("#include <string.h>\n");
	ofileImp.printf("\n");
	return err;
}

BString GenBoapMcComms::getTypeSwapList(Node* n){
	BString	typeName;
	Type*	t;
	BIter	i;
	BString	typeList;

	typeName = n->name();
//	printf("isRawType: %d %s\n", n->nodeType(), typeName.retStr());

	if(n->nodeType() == Node::TTYPEARRAY){
		return "";
	}
	else if(n->nodeType() == Node::TTYPEDICT){
		return "";
	}
	else if(n->nodeType() == Node::TTYPE){
		if(typeName == "Int8")		return "1";
		else if(typeName == "UInt8")	return "1";
		else if(typeName == "Int16")	return "2";
		else if(typeName == "UInt16")	return "2";
		else if(typeName == "Int32")	return "4";
		else if(typeName == "UInt32")	return "4";
		else if(typeName == "Bool")	return "4";
		else if(typeName == "String")	return "";
		else if(typeName == "Error")	return "";
		else if(typeName == "Date")	return "";
		else if(typeName == "DateTime")	return "";
		else if(typeName == "Id")	return "";
		else if(typeName == "ObjData")	return "";
		else if(typeName == "TimeStamp")	return "";
		else if(typeName == "Complex")	return "";
		else {
			if(t = gtypelist.search(typeName)){
				if(t->node()){
					return  getTypeSwapList(t->node());
				}
			}
			else
				return "";
		}
	}
	else if(n->nodes().number()){
		for(n->nodes().start(i); !n->nodes().isEnd(i); n->nodes().next(i)){
			typeList += getTypeSwapList(n->nodes()[i]);
		}

		return typeList;
	}
	return "";
}



GenBoapMcComms::GenBoapMcComms(){
	ofuncNum = 0;
	opushPopDepth = 0;
	oapiVersion = 0;
	
	setUseBObjects(0);
}

GenBoapMcComms::~GenBoapMcComms(){
}

BError GenBoapMcComms::produce(Node* n, BString fileName){
	BError	err;
	
//	dprintf("GenBoapMc::produce: %x\n", n);
	ofileName = fileName;
	ofileInt.open(fileName + "B.h", "w");
	ofileImp.open(fileName + "B.cpp", "w");

	// File Headers
	produceHeaderInt();
	produceHeaderImp();
	
	// Generate code
	produceInt(n, 0);
	produceImp(n, 0);
	
	// Generate trailers
	produceTrailerInt();
	ofileImp.close();
	ofileInt.close();
	return err;
}

