/*
* Title:	Control.h
* Author:	M.Thomas BEAM Ltd
* Date:		2007-02-13
*
* Contents:	All GUI access to the Tms server is routed through this class.
*
* Mod Rec:
*
*/

#ifndef CONTROL_H
#define CONTROL_H	1

#include <BError.h>
#include <BString.h>
#include <TmsD.h>
#include <TmsC.h>
#include <qobject.h>

/// The main system control class
class Control : public QObject {
	Q_OBJECT
public:
			Control();
			~Control();
	
	void	setHost(BString name);				///< Set hostname of server
	
	BError	init();						///< Initialise the system
	BError	connect();					///< Connect to both Control and Process

	BError	reconfigure(Tms::ConfigInfo i);			///< Reconfigure the system
	BError	getConfiguration(Tms::ConfigInfo& i);		///< Get current configuration
	
	BError	runTest(BList<BError>& l);			///< Run the server selftest

	BError	getData(Tms::DataInfo info,Tms::Data& data);
	BError	getStatus(BList<Tms::NameValue>& l);		///< Get Status
	BError	getStatistics(BList<Tms::NameValue>& l);	///< Get Statistics

	BError	setControlInfo(Tms::CycleParam	params);	///< Setup Cycle parameters
	BError  getControlInfo(BString cycleType, UInt32 puChannel, Tms::CycleParam& params);	///< Gets the control information for the cycle type and puChannel number given. The call will return an error object indicating success or an error

	BError	getPuChannel (UInt32 puChannel, Tms::PuChannel &puPhysChannel);		///< Get a handle for vitrual channel
	BError	getCycleInfo(UInt32& cycleNumber,BString& cycleType);			
	
	BError	setNextCycle(UInt32 cycleNumber,BString cycleType);

	BError	setTestData(Tms::PuChannel puChannel,Int32 on, BArray<UInt32> data);					///< Set pupe test data
	BError	getTestData(Tms::PuChannel puPhysChannel, Tms::TestCaptureInfo captureInfo, BArray< UInt64 > &data); 	///< Fetch pupe test data

	BError	initialiseServer();	
	BError	setPupeConfig(Tms::PuChannel puChannel,Tms::PupeConfig pupeConfig);
	BError	getPupeConfig(Tms::PuChannel puChannel,Tms::PupeConfig& pupeConfig);
			
	BError getControlList(BList<Tms::CycleParamItem>& itemList);		///< Gets the list of Cycle Parameters present in the system



signals:
	void 	newConnection();				///< Signals a new connection made

private:
	BString			ohostName;
	Tms::TmsControl		otmsControl;
	Tms::TmsProcess		otmsProcess;
};

#endif
