#ifndef _ADATA_ADB3_H
#define _ADATA_ADB3_H

/*
** <adb3.h> - ADB3 API header file (ADB3 interface)
**
** (C) Copyright 2011 Alpha Data
**
** The integer datatypes used below that are prefixed by "_ADB3_", such
** as "_ADB3_UINT64" are defined in order to increase the portability of
** this header file but should NOT be used by application code that makes
** use of the ADB3 API.
**
** Applications should use OS-specific types such as UINT32 (Windows) or
** uint32_t (Linux C99).
*/

#if defined(_WIN32) || defined(_MSC_VER)

/* Windows */

# include <windows.h>
# include <tchar.h>

# if defined(ADB3_DLL)
    /* Compiling API library into a DLL */
#   define ADB3_EXPORT __declspec(dllexport)
# else
    /* Importing API library from DLL */
#   define ADB3_EXPORT __declspec(dllimport)
# endif
# define ADB3_CALLING_CONVENTION __cdecl

#elif defined(__linux)

/* Linux */

# include <stdint.h>
# include <wchar.h>

# define ADB3_EXPORT
# define ADB3_CALLING_CONVENTION

#elif defined(__VXWORKS__) || defined(__vxworks)

# include <vxWorks.h>
# include <semLib.h>

# define ADB3_EXPORT
# define ADB3_CALLING_CONVENTION

#else

# error Cannot detect target operating system.

#endif

#include <adb3/platform.h>
#include <adb3/status.h>
#include <adb3/types.h>
#include <adb3/structs.h>

/* Revision of the ADB3 API */
#define ADB3_H_MAKE_VERSION(super, major, minor) ((super) * 65536 + (major) * 256 + (minor))
#define ADB3_H_VERSION_SUPER (2)
#define ADB3_H_VERSION_MAJOR (0)
#define ADB3_H_VERSION_MINOR (0)
#define ADB3_H_VERSION ADB3_H_MAKE_VERSION(ADB3_H_VERSION_SUPER, ADB3_H_VERSION_MAJOR, ADB3_H_VERSION_MINOR)

/*
** Function prototypes
*/
#ifdef __cplusplus
extern "C" {
#endif

ADB3_EXPORT ADB3_STATUS
ADB3_CALLING_CONVENTION
ADB3_Close(
  ADB3_HANDLE             hCard);

ADB3_EXPORT ADB3_STATUS
ADB3_CALLING_CONVENTION
ADB3_GetProdTestInfo(
  ADB3_HANDLE hCard,
  ADB3_PRODTEST_INFO*     pProdTestInfo);

#if defined(_UNICODE)
# define ADB3_GetStatusString ADB3_GetStatusStringW
#else
# define ADB3_GetStatusString ADB3_GetStatusStringA
#endif

ADB3_EXPORT const char*
ADB3_CALLING_CONVENTION
ADB3_GetStatusStringA(
  ADB3_STATUS             code,
  _ADB3_BOOL              bShort);

ADB3_EXPORT const wchar_t*
ADB3_CALLING_CONVENTION
ADB3_GetStatusStringW(
  ADB3_STATUS             code,
  _ADB3_BOOL              bShort);

ADB3_EXPORT ADB3_STATUS
ADB3_CALLING_CONVENTION
ADB3_GetUniqueId(
  ADB3_HANDLE hCard,
  ADB3_UNIQUE_ID*         pUniqueId);

ADB3_EXPORT ADB3_STATUS
ADB3_CALLING_CONVENTION
ADB3_Open(
  unsigned int            index,
  _ADB3_BOOL              bPassive,
  _ADB3_UINT32            cooperativeLevel,
  ADB3_HANDLE*            phCard);

ADB3_EXPORT ADB3_STATUS
ADB3_CALLING_CONVENTION
ADB3_ServiceIRQ(
  ADB3_HANDLE             hCard,
  _ADB3_BOOL*             pbServiced);

#ifdef __cplusplus
}
#endif

#endif
