/*
** File: linux-2.6.c  
** Project: Linux ADM-XRC monolithic driver
** Purpose: Entry point for kernel module and other Linux-specific declarations.
**
** (C) Copyright Alpha Data 2013
*/

#include <linux/module.h>
#include <linux/init.h>

#include "df.h"
#include "dflinux.h"

static const char* g_pciDriverName = "admxrc2";

MODULE_LICENSE("GPL");

/*
** Module parameters
*/

static uint Admxrc6tadv8CompatSensor1Name = 0;
module_param(Admxrc6tadv8CompatSensor1Name, uint, S_IRUGO);
static uint AssumeXrmPresent = 0;
module_param(AssumeXrmPresent, uint, S_IRUGO);
static uint DebugLevel = 0;
module_param(DebugLevel, uint, S_IRUGO);
static uint DmaMapLength = 64;
module_param(DmaMapLength, uint, S_IRUGO);
static uint EnableVpdWrite = 0;
module_param(EnableVpdWrite, uint, S_IRUGO);
static uint IncludeDiagSensors = 0;
module_param(IncludeDiagSensors, uint, S_IRUGO);
static uint LegacyHardware = 0;
module_param(LegacyHardware, uint, S_IRUGO);
static uint PciAddress64Bit = 0;
module_param(PciAddress64Bit, uint, S_IRUGO);
static uint Si5338ExposeAllClocks = 0;
module_param(Si5338ExposeAllClocks, uint, S_IRUGO);
static uint PrimaryCommonBufferCount = 0;
module_param(PrimaryCommonBufferCount, uint, S_IRUGO);
static uint PrimaryCommonBufferAlignment = 16U;
module_param(PrimaryCommonBufferAlignment, uint, S_IRUGO);
static uint PrimaryCommonBufferSizeLow = 0x10000U;
module_param(PrimaryCommonBufferSizeLow, uint, S_IRUGO);
static uint PrimaryCommonBufferSizeHigh = 0;
module_param(PrimaryCommonBufferSizeHigh, uint, S_IRUGO);
static uint PolledInterrupts = 0;
module_param(PolledInterrupts, uint, S_IRUGO);
static uint ADMPCIE6S1FreqStepRefClk200 = 100000U;
module_param(ADMPCIE6S1FreqStepRefClk200, uint, S_IRUGO);
static uint ADMPCIE6S1FreqStepMClk = 100000U;
module_param(ADMPCIE6S1FreqStepMClk, uint, S_IRUGO);
static uint ADMPCIE6S1FreqStepLClk = 100000U;
module_param(ADMPCIE6S1FreqStepLClk, uint, S_IRUGO);
static uint ADMPCIE6S1GlitchFreeRefClk200 = 0U;
module_param(ADMPCIE6S1GlitchFreeRefClk200, uint, S_IRUGO);
static uint ADMPCIE6S1GlitchFreeMClk = 0U;
module_param(ADMPCIE6S1GlitchFreeMClk, uint, S_IRUGO);

DfLinuxDriverParameterUint32 g_dfLinuxDriverParamUint32[] = {
  { "Admxrc6tadv8CompatSensor1Name", &Admxrc6tadv8CompatSensor1Name },
  { "DebugLevel", &DebugLevel },
  { "DmaMapLength", &DmaMapLength },
  { "PrimaryCommonBufferCount", &PrimaryCommonBufferCount },
  { "PrimaryCommonBufferAlignment", &PrimaryCommonBufferAlignment },
  { "PrimaryCommonBufferSizeLow", &PrimaryCommonBufferSizeLow },
  { "PrimaryCommonBufferSizeHigh", &PrimaryCommonBufferSizeHigh },
  { "ADMPCIE6S1FreqStepRefClk200", &ADMPCIE6S1FreqStepRefClk200 },
  { "ADMPCIE6S1FreqStepMClk", &ADMPCIE6S1FreqStepMClk },
  { "ADMPCIE6S1FreqStepLClk", &ADMPCIE6S1FreqStepLClk },
  { NULL, NULL } /* Terminator */
};
  
DfLinuxDriverParameterBoolean g_dfLinuxDriverParamBoolean[] = {
  { "AssumeXrmPresent", &AssumeXrmPresent },
  { "EnableVpdWrite", &EnableVpdWrite },
  { "IncludeDiagSensors", &IncludeDiagSensors },
  { "LegacyHardware", &LegacyHardware },
  { "PciAddress64Bit", &PciAddress64Bit },
  { "Si5338ExposeAllClocks", &Si5338ExposeAllClocks },
  { "PolledInterrupts", &PolledInterrupts },
  { "ADMPCIE6S1GlitchFreeRefClk200", &ADMPCIE6S1GlitchFreeRefClk200 },
  { "ADMPCIE6S1GlitchFreeMClk", &ADMPCIE6S1GlitchFreeMClk },
  { NULL, NULL } /* Terminator */
};
  
DfLinuxDriverParameterString g_dfLinuxDriverParamString[] = {
  { NULL, NULL } /* Terminator */
};
  
/*
** PCI ID table used by hotplug subsystem. The table is in two parts, where the second part is for legacy ID.
** By putting NULL ID after the first part of the table, legacy hardware support is NOT advertised to the
** hotplug subsystem (intentional).
**
** If TRUE is passed in bSupportLegacyHardware, dfLinuxModuleInitPci() function removes the NULL ID after the
** first part and shifts the second part entries down, so that legacy hardware will be registered when the driver
** calls pci_register_driver.
**
** !!!NOTE!!! If there is no legacy hardware, the table MUST end with two NULL PCI ID records, e.g.
**
** static struct pci_device_id g_pciIdTable[] = {
**   { .vendor = ..., .device = ..., .subvendor = ..., .subdevice = ... },
**   { .vendor = ..., .device = ..., .subvendor = ..., .subdevice = ... },
**   { .vendor = 0x0U, .device = 0x0U },
**   { .vendor = 0x0U, .device = 0x0U }
** }
**
** In other words, if there is no legacy hardware, then do not remove the NULL ID for terminating the legacy
** hardware part of the table.
*/
static struct pci_device_id g_pciIdTable[] = {
  { .vendor = 0x10b5U, .device = 0x9080U, .subvendor = 0x4144U, .subdevice = 0x0040U }, /* ADM-XRC / ADM-XRC-P */
  { .vendor = 0x10b5U, .device = 0x9080U, .subvendor = 0x4144U, .subdevice = 0x0041U }, /* ADM-XRC-II-Lite */
  { .vendor = 0x10b5U, .device = 0x9080U, .subvendor = 0x4144U, .subdevice = 0x0042U }, /* ADM-XRC-II */
  { .vendor = 0x4144U, .device = 0x0043U, .subvendor = 0x4144U, .subdevice = 0x0047U }, /* ADM-XPL (PCI) */
  { .vendor = 0x4144U, .device = 0x0043U, .subvendor = 0x4144U, .subdevice = 0x0043U }, /* ADM-XPL (PCI-X) */
  { .vendor = 0x4144U, .device = 0x0044U, .subvendor = 0x4144U, .subdevice = 0x0044U }, /* ADM-XP (PCI) */
  { .vendor = 0x4144U, .device = 0x0044U, .subvendor = 0x4144U, .subdevice = 0x0048U }, /* ADM-XP (PCI-X) */
  { .vendor = 0x10b5U, .device = 0x9656U, .subvendor = 0x4144U, .subdevice = 0x0045U }, /* ADP-WRC-II */
  { .vendor = 0x10b5U, .device = 0x9656U, .subvendor = 0x4144U, .subdevice = 0x0046U }, /* ADP-WRC-II */
  { .vendor = 0x4144U, .device = 0x0049U, .subvendor = 0x4144U, .subdevice = 0x0049U }, /* ADP-XPI (PCI) */
  { .vendor = 0x4144U, .device = 0x0049U, .subvendor = 0x4144U, .subdevice = 0x004AU }, /* ADP-XPI (PCI-X) */
  { .vendor = 0x10b5U, .device = 0x9656U, .subvendor = 0x4144U, .subdevice = 0x004CU }, /* ADM-XRC-4LX */
  { .vendor = 0x10b5U, .device = 0x9656U, .subvendor = 0x4144U, .subdevice = 0x004DU }, /* ADM-XRC-4SX */
  { .vendor = 0x4144U, .device = 0x004EU, .subvendor = 0x4144U, .subdevice = 0x004EU }, /* ADPE-XRC-4FX */
  { .vendor = 0x4144U, .device = 0x004FU, .subvendor = 0x4144U, .subdevice = 0x004FU }, /* ADM-XRC-4FX / ADM-XMC-4FX */
  { .vendor = 0x4144U, .device = 0x0050U, .subvendor = 0x4144U, .subdevice = 0x0050U }, /* ADM-XRC-5LX */
  { .vendor = 0x4144U, .device = 0x0051U, .subvendor = 0x4144U, .subdevice = 0x0051U }, /* ADM-XRC-5T1 */
  { .vendor = 0x4144U, .device = 0x0052U, .subvendor = 0x4144U, .subdevice = 0x0052U }, /* ADM-XRC-5T2 */
  { .vendor = 0x4144U, .device = 0x0053U, .subvendor = 0x4144U, .subdevice = 0x0053U }, /* ADM-XRC-5LXA */
  { .vendor = 0x4144U, .device = 0x0054U, .subvendor = 0x4144U, .subdevice = 0x0054U }, /* ADCP-XRC-4LX */
  { .vendor = 0x4144U, .device = 0x0056U, .subvendor = 0x4144U, .subdevice = 0x0056U }, /* ADM-AMC-5A2 */
  { .vendor = 0x4144U, .device = 0x0057U, .subvendor = 0x4144U, .subdevice = 0x0057U }, /* ADM-XRC-5TZ */
  { .vendor = 0x4144U, .device = 0x0059U, .subvendor = 0x4144U, .subdevice = 0x0059U }, /* ADC-BBP */
  { .vendor = 0x4144U, .device = 0x005BU, .subvendor = 0x4144U, .subdevice = 0x005BU }, /* ADM-XRC-5T2-ADV */
  { .vendor = 0x4144U, .device = 0x005CU, .subvendor = 0x4144U, .subdevice = 0x005CU }, /* ADM-XRC-5T-DA1 */
  { .vendor = 0x4144U, .device = 0x005DU, .subvendor = 0x4144U, .subdevice = 0x005DU }, /* ADM-XRC-5T1(V) */
  { .vendor = 0x4144U, .device = 0x005FU, .subvendor = 0x4144U, .subdevice = 0x005FU }, /* ADM-XRC-5T2-ADV6 */
  { .vendor = 0x4144U, .device = 0x0060U, .subvendor = 0x4144U, .subdevice = 0x0060U }, /* ADM-XRC-5T2-ADV-CC1 */
  { .vendor = 0x10b5U, .device = 0x9056U, .subvendor = 0x4144U, .subdevice = 0x0080U }, /* ADM-PCIE-6S1 */
  { .vendor = 0x0000U, .device = 0x0000U }, /* Marks end of table */
  { .vendor = 0x0000U, .device = 0x0000U }  /* Marks end of table */
};

#if 0
/* When we have sorted out udev, we can enable the MODULE_DEVICE_TABLE so that the module loads automatically instead of via adb3.rc script */
MODULE_DEVICE_TABLE(pci, g_pciIdTable);
#endif

/*
** Module entry / exit points
*/

int __init
adb3Init(
  void)
{
#if DF_DBG_BUILD
  g_dfDebugLevel = (int)DebugLevel;
#endif
  return dfLinuxModuleInitPci(g_pciDriverName, g_pciIdTable, LegacyHardware ? TRUE : FALSE);
}

void __exit
adb3Exit(
  void)
{
  dfLinuxModuleExitPci();

#if DF_DBG_ALLOCATION
  dfLinuxReportLeaks();
#endif
}

module_init(adb3Init)
module_exit(adb3Exit)
