/*
** File: pio.h  
** Project: ADMXRC2 module driver
** Purpose: Defines function prototypes for programmed I/O IOCTL handlers.
**
** (C) Copyright Alpha Data 2013
*/

#if !defined(ADATA_ADMXRC2_PIO_H)
#define ADATA_ADMXRC2_PIO_H

#include <df.h>
#include "device.h"

extern DfIoStatus
ioctlRead(
	Admxrc2DeviceContext* pDevCtx,
	Admxrc2ClientContext* pClCtx,
  DfClientRequest* pReq,
  void* pBuffer,
  unsigned int inSize);

#if DF_NEED_THUNK
extern DfIoStatus
ioctlReadThunk(
	Admxrc2DeviceContext* pDevCtx,
	Admxrc2ClientContext* pClCtx,
  DfClientRequest* pReq,
  void* pBuffer,
  unsigned int inSize);
#endif

extern DfIoStatus
ioctlWrite(
	Admxrc2DeviceContext* pDevCtx,
	Admxrc2ClientContext* pClCtx,
  DfClientRequest* pReq,
  void* pBuffer,
  unsigned int inSize);

#if DF_NEED_THUNK
extern DfIoStatus
ioctlWriteThunk(
	Admxrc2DeviceContext* pDevCtx,
	Admxrc2ClientContext* pClCtx,
  DfClientRequest* pReq,
  void* pBuffer,
  unsigned int inSize);
#endif

#endif
