/*
** File: flash.h  
** Project: ADMXRC2 module driver
** Purpose: Defines function prototypes for Flash programming IOCTL handlers.
**
** (C) Copyright Alpha Data 2013
*/

#if !defined(ADATA_ADMXRC2_FLASH_H)
#define ADATA_ADMXRC2_FLASH_H

#include <df.h>
#include "device.h"

extern void
syncFlashOnClose(
	Admxrc2DeviceContext* pDevCtx,
	Admxrc2ClientContext* pClCtx,
  unsigned int bankIndex);

extern DfIoStatus
ioctlEraseFlash(
	Admxrc2DeviceContext* pDevCtx,
	Admxrc2ClientContext* pClCtx,
  void* pBuffer,
  unsigned int inSize);

extern DfIoStatus
ioctlGetFlashBlockInfo(
	Admxrc2DeviceContext* pDevCtx,
  void* pBuffer,
  unsigned int inSize,
  unsigned int outSize);

extern DfIoStatus
ioctlGetFlashInfo(
	Admxrc2DeviceContext* pDevCtx,
  void* pBuffer,
  unsigned int inSize,
  unsigned int outSize);

extern DfIoStatus
ioctlReadFlash(
	Admxrc2DeviceContext* pDevCtx,
	Admxrc2ClientContext* pClCtx,
  void* pBuffer,
  unsigned int inSize);

#if DF_NEED_THUNK
extern DfIoStatus
ioctlReadFlashThunk(
	Admxrc2DeviceContext* pDevCtx,
	Admxrc2ClientContext* pClCtx,
  void* pBuffer,
  unsigned int inSize);
#endif

extern DfIoStatus
ioctlSyncFlash(
	Admxrc2DeviceContext* pDevCtx,
	Admxrc2ClientContext* pClCtx,
  void* pBuffer,
  unsigned int inSize);

extern DfIoStatus
ioctlWriteFlash(
	Admxrc2DeviceContext* pDevCtx,
	Admxrc2ClientContext* pClCtx,
  DfClientRequest* pReq,
  void* pBuffer,
  unsigned int inSize);

#if DF_NEED_THUNK
extern DfIoStatus
ioctlWriteFlashThunk(
	Admxrc2DeviceContext* pDevCtx,
	Admxrc2ClientContext* pClCtx,
  DfClientRequest* pReq,
  void* pBuffer,
  unsigned int inSize);
#endif

#endif
