/*
** File: event.h  
** Project: ADMXRC2 module driver
** Purpose: Defines function prototypes for event registration and wait IOCTL handlers.
**
** (C) Copyright Alpha Data 2013
*/

#if !defined(ADATA_ADMXRC2_EVENT_H)
#define ADATA_ADMXRC2_EVENT_H

#include <df.h>
#include "device.h"

extern void
fpgaInterruptNotifyCallback(
  CoreNotification* pNotification,
  unsigned int notifyType,
  void* pCallbackContext);

extern void
fpgaAlertNotifyCallback(
  CoreNotification* pNotification,
  unsigned int notifyType,
  void* pCallbackContext);

#if DF_HAS_USER_EVENT_HANDLE

extern void
cleanupUserEvents(
	Admxrc2DeviceContext* pDevCtx,
  Admxrc2ClientContext* pClCtx);

extern DfIoStatus
ioctlRegisterEvent(
	Admxrc2DeviceContext* pDevCtx,
  Admxrc2ClientContext* pClCtx,
  void* pBuffer,
  unsigned int inSize);

# if DF_NEED_THUNK
extern DfIoStatus
ioctlRegisterEventThunk(
	Admxrc2DeviceContext* pDevCtx,
  Admxrc2ClientContext* pClCtx,
  void* pBuffer,
  unsigned int inSize);
#endif

extern DfIoStatus
ioctlUnregisterEvent(
	Admxrc2DeviceContext* pDevCtx,
  Admxrc2ClientContext* pClCtx,
  void* pBuffer,
  unsigned int inSize);

# if DF_NEED_THUNK
extern DfIoStatus
ioctlUnregisterEventThunk(
	Admxrc2DeviceContext* pDevCtx,
  Admxrc2ClientContext* pClCtx,
  void* pBuffer,
  unsigned int inSize);
# endif

#endif

extern DfIoStatus
ioctlCancelWaitForInterrupt(
	Admxrc2DeviceContext* pDevCtx,
  Admxrc2ClientContext* pClCtx,
  void* pBuffer,
  unsigned int inSize);

extern DfIoStatus
ioctlWaitForInterrupt(
	Admxrc2DeviceContext* pDevCtx,
  Admxrc2ClientContext* pClCtx,
  DfClientRequest* pRequest,
  void* pBuffer,
  unsigned int inSize,
  unsigned int outSize);

#endif
