/*
** File: coop.c  
** Project: ADMXRC2 module driver
** Purpose: OS-independent IOCTL handlers for setting and getting clock
**          generator frequencies.
**
** (C) Copyright Alpha Data 2013
*/

#include <df.h>
#include "device.h"
#include "coop.h"
#include <admxrc2/types.h>

DfIoStatus
ioctlSetCoopLevel(
	Admxrc2DeviceContext* pDevCtx,
	Admxrc2ClientContext* pClCtx,
  void* pBuffer,
  unsigned int inSize)
{
  IOCTLS_ADMXRC2_SETCOOPLEVEL* pIoctl = (IOCTLS_ADMXRC2_SETCOOPLEVEL*)pBuffer;
  uint32_t coopLevel;
  CoreCoopLevel coreCoopLevel;
  boolean_t bSuccess;

  if (NULL == pIoctl || sizeof(pIoctl->in) != inSize) {
    return DfIoStatusInvalid;
  }
  if (!pClCtx->bPrivileged) {
    return DfIoStatusError(ADMXRC2_ACCESS_DENIED);
  }

  coopLevel = pIoctl->in.coopLevel;
  switch (coopLevel) {
  case ADMXRC2_COOP_NORMAL:
    coreCoopLevel = CoreCoopLevelNormal;
    break;

  case ADMXRC2_COOP_EXCLUSIVE:
    coreCoopLevel = CoreCoopLevelExclusive;
    break;

  default:
    return ADMXRC2_INVALID_PARAMETER;
  }

  /* TRUE passed for bIncCountOnSuccess; we will correct it if necessary below */
  bSuccess = pDevCtx->coreInterface.pSetCoopLevel(pDevCtx->pCoreContext, &pClCtx->coreClient, coopLevel);
  if (!bSuccess) {
    /* Somebody else has already set the device to exclusive */
    return DfIoStatusError(ADMXRC2_CARD_BUSY);
  }

  /* Permits state-changing IOCTLs to succeed without "access denied" error. */
  pClCtx->bCoopLevelIsSet = TRUE;

  return DfIoStatusSuccess;
}
