/*
** File: pool.c  
** Project: Linux Driver Framework
** Purpose: Pool creation and destruction functions
**
** (C) Copyright Alpha Data 2010
*/

#include "df.h"
#include "dflinux.h"

boolean_t
_dfPoolInit(
  DfPool* pPool,
  DfDeviceObject* pDevObj,
  const char* pName,
  size_t itemSize)
{
  /* Ensure that name of cache is unique */
  if (NULL != pDevObj) {
    snprintf(pPool->system.name, DFPOOL_NAME_MAX_LENGTH, "%s:%u:%s", g_dfDriverName, pDevObj->index, pName);
  } else {
    snprintf(pPool->system.name, DFPOOL_NAME_MAX_LENGTH, "%s:%s", g_dfDriverName, pName);
  }
  pPool->system.name[DFPOOL_NAME_MAX_LENGTH - 1] = '\0';
#if KMEM_CACHE_CREATE_5
  pPool->system.pCache = kmem_cache_create(pPool->system.name, itemSize, 0, SLAB_HWCACHE_ALIGN, NULL);
#else
  pPool->system.pCache = kmem_cache_create(pPool->system.name, itemSize, 0, SLAB_HWCACHE_ALIGN, NULL, NULL);
#endif
  if (NULL == pPool->system.pCache) {
    return FALSE;
  }
#if DF_DBG_BUILD && DF_DBG_ALLOCATION
  pPool->system.itemSize = itemSize;
#endif

  return TRUE;
}

void
dfPoolUninit(
  DfPool* pPool)
{
#if DF_DBG_BUILD && DF_DBG_ALLOCATION
  dfAssert(NULL != pPool->system.pCache);
#endif
  if (NULL != pPool->system.pCache) {
    kmem_cache_destroy(pPool->system.pCache);
    pPool->system.pCache = NULL;
  }
}
