/*
** File: drvparam.c  
** Project: Linux Driver Framework
** Purpose: Mechanism by which OS-independent driver code can obtain values of
**          driver parameters.
**
** (C) Copyright Alpha Data 2010
*/

#include "df.h"
#include "dflinux.h"

extern DfParameterStatus
dfParameterGetUint32(
  DfDriverObject* pDrvObj,
  const char* pKeyName,
  uint32_t* pValue)
{
  DfLinuxDriverParameterUint32* pParam;
  unsigned int i;

  for (i = 0;; i++) {
    pParam = &g_dfLinuxDriverParamUint32[i];
    if (NULL == pParam->pName) {
      pParam = NULL;
      break;
    }
    if (strcmp(pKeyName, pParam->pName) == 0) {
      break;
    }
  }

  if (NULL == pParam) {
    return DfParameterNotFound;
  }

  *pValue = (uint32_t)*(pParam->pValue);
  return DfParameterSuccess;
}

extern DfParameterStatus
dfParameterGetBoolean(
  DfDriverObject* pDrvObj,
  const char* pKeyName,
  boolean_t* pValue)
{
  DfLinuxDriverParameterBoolean* pParam;
  unsigned int i;

  for (i = 0;; i++) {
    pParam = &g_dfLinuxDriverParamBoolean[i];
    if (NULL == pParam->pName) {
      pParam = NULL;
      break;
    }
    if (strcmp(pKeyName, pParam->pName) == 0) {
      break;
    }
  }

  if (NULL == pParam) {
    return DfParameterNotFound;
  }

  *pValue = *(pParam->pValue) ? TRUE : FALSE;
  return DfParameterSuccess;
}

extern DfParameterStatus
dfParameterGetString(
  DfDriverObject* pDrvObj,
  const char* pKeyName,
  size_t bufferSize,
  size_t* pBufferNeeded,
  char* pBuffer)
{
  DfLinuxDriverParameterString* pParam;
  unsigned int i;
  size_t n;

  for (i = 0;; i++) {
    pParam = &g_dfLinuxDriverParamString[i];
    if (NULL == pParam->pName) {
      pParam = NULL;
      break;
    }
    if (strcmp(pKeyName, pParam->pName) == 0) {
      break;
    }
  }

  if (NULL == pParam) {
    return DfParameterNotFound;
  }

  n = strlen(pParam->pValue) + 1;
  if (NULL != pBufferNeeded) {
    *pBufferNeeded = n;
  }
  if (NULL != pBuffer) {
    if (n <= bufferSize) {
      memcpy(pBuffer, pParam->pValue, n);
    } else {
      memcpy(pBuffer, pParam->pValue, bufferSize - 1);
      pBuffer[bufferSize - 1] = '\0';
    }
  }

  return DfParameterSuccess;
}

extern DfParameterStatus
dfParameterGetStringAlloc(
  DfDriverObject* pDrvObj,
  const char* pKeyName,
  char** ppBuffer)
{
  DfLinuxDriverParameterString* pParam;
  unsigned int i;
  size_t n;
  char* pBuffer;

  for (i = 0;; i++) {
    pParam = &g_dfLinuxDriverParamString[i];
    if (NULL == pParam->pName) {
      pParam = NULL;
      break;
    }
    if (strcmp(pKeyName, pParam->pName) == 0) {
      break;
    }
  }

  if (NULL == pParam) {
    return DfParameterNotFound;
  }

  n = strlen(pParam->pValue) + 1;
  pBuffer = (char*)dfMalloc(n);
  if (NULL == pBuffer) {
    *ppBuffer = NULL;
    return DfParameterNoMemory;
  }
  memcpy(pBuffer, pParam->pValue, n);
  *ppBuffer = pBuffer;
  return DfParameterSuccess;
}
