/*
** File: v6clksynth.h  
** Project: ADB3 core driver
** Purpose: Definitions for Virtex-6 MMCM clock synthesizer
**
** (C) Copyright Alpha Data 2011
**
** See XAPP878 for information about MMCM DRP registers.
*/

#ifndef _ADATA_CORE_V6CLKSYNTH_H
#define _ADATA_CORE_V6CLKSYNTH_H

#include <df.h>
#include "coreif.h"

struct _Adb3CoreDeviceContext;
struct _V6ClkSynthProgramRequest;
typedef struct _V6ClkSynthProgramRequest V6ClkSynthProgramRequest;
struct _V6ClkSynthProgramRequestSync;
typedef struct _V6ClkSynthProgramRequestSync V6ClkSynthProgramRequestSync;

/* Delay from powering up an MMCM to first DRP access, in microseconds */
#define V6CLKSYNTH_POWER_UP_MMCM_DELAY        (5000U)

/* Delay from deasserting MMCM reset to checking for LOCK, in microseconds */
#define V6CLKSYNTH_MMCM_LOCK_DELAY            (5000U)

typedef struct _V6ClkSynthDeviceContext {
  uint32_t lclkCtlShadow;  /* Shadow of LCLOCK register in model-specific registers */
  DfTimer timer;           /* Timer for checking that clock synthesizer programming was successful */
  struct { /* Used to save & restore state when powering down & up */
    CoreClockWord last;
    boolean_t bLastValid;
  } save;
} V6ClkSynthDeviceContext;

typedef enum _V6ClkSynthClockWordStatus {
  V6ClkSynthClockWordStatusSuccess = 0,
  V6ClkSynthClockWordStatusOutOfRange = 1,
  V6ClkSynthClockWordStatusGeneralFailure = 2
} V6ClkSynthClockWordStatus;

typedef enum _V6ClkSynthProgramStatus {
  V6ClkSynthProgramStatusSuccess = 0,
  V6ClkSynthProgramStatusHardwareError = 1,
  V6ClkSynthProgramStatusGeneralFailure = 2
} V6ClkSynthProgramStatus;

typedef void V6ClkSynthProgramCallback(struct _Adb3CoreDeviceContext* pDevCtx, V6ClkSynthDeviceContext* pV6ClkSynthCtx, V6ClkSynthProgramRequest* pRequest, V6ClkSynthProgramStatus status);

struct _V6ClkSynthProgramRequest {
  V6ClkSynthDeviceContext* pV6ClkSynthCtx;
  V6ClkSynthProgramCallback* pCallback;
  CoreClockWord clockWord;
};

struct _V6ClkSynthProgramRequestSync {
  V6ClkSynthProgramRequest request;
  DfEvent ev;
  V6ClkSynthProgramStatus status;
};

#endif
