/*
** File: avr.h  
** Project: ADB3 core driver
** Purpose: Exports definitions for the the AVR uC interface
**
** (C) Copyright Alpha Data 2011
*/

#ifndef _ADATA_CORE_AVR_H
#define _ADATA_CORE_AVR_H

#include <df.h>

/* Fields for ModelRegsAdmxrc6tx::model4::avr::ctlStat */
/* 31:16 - UART clock divide */
/*    15 - Single line from Bridge to uC */
/*    14 - 1 => board is in "service mode" (no sensor info; not monitoring board health) */
/*    13 - (reserved) */
/*    12 - 1 => TX FIFO empty */
/*    11 - 1 => RX FIFO full */
/*    10 - R: 1 => TX FIFO full; W: write 1 to transmit bits 7:0 to uC via TX FIFO */
/*    9  - R: 1 => RX FIFO empty: W: write 1 to advance RX FIFO read pointer */
/*    8  - 1 => enable service command (must be set for all characters making up a service command) */
/*  7:0  - Character to transmit */

/* AVR control register fields */
#define ADMXRC6Tx_S_AVRCTL_DATA            (0)
#define ADMXRC6Tx_L_AVRCTL_DATA            (8)
#define ADMXRC6Tx_M_AVRCTL_DATA            DF_MASK32S(ADMXRC6Tx_S_AVRCTL_DATA, ADMXRC6Tx_L_AVRCTL_DATA)
#define ADMXRC6Tx_V_AVRCTL_DATA(x)         DF_VAL32S(x, ADMXRC6Tx_S_AVRCTL_DATA, ADMXRC6Tx_L_AVRCTL_DATA)
#define ADMXRC6Tx_V_AVRCTL_FLASH           DF_VAL32S(0x1U, 8, 1)
#define ADMXRC6Tx_V_AVRCTL_RX              DF_VAL32S(0x1U, 9, 1)
#define ADMXRC6Tx_V_AVRCTL_TX              DF_VAL32S(0x1U, 10, 1)

/* AVR status register fields */
#define ADMXRC6Tx_S_AVRSTAT_DATA           (0)
#define ADMXRC6Tx_L_AVRSTAT_DATA           (8)
#define ADMXRC6Tx_M_AVRSTAT_DATA           DF_MASK32S(ADMXRC6Tx_S_AVRSTAT_DATA, ADMXRC6Tx_L_AVRSTAT_DATA)
#define ADMXRC6Tx_E_AVRSTAT_DATA(x)        DF_EX8S(x, ADMXRC6Tx_S_AVRSTAT_DATA, ADMXRC6Tx_L_AVRSTAT_DATA)
#define ADMXRC6Tx_V_AVRSTAT_RX_EMPTY       DF_VAL32S(0x1U, 9, 1)
#define ADMXRC6Tx_V_AVRSTAT_TX_FULL        DF_VAL32S(0x1U, 10, 1)
#define ADMXRC6Tx_V_AVRSTAT_RX_FULL        DF_VAL32S(0x1U, 11, 1)
#define ADMXRC6Tx_V_AVRSTAT_TX_EMPTY       DF_VAL32S(0x1U, 12, 1)
#define ADMXRC6Tx_V_AVRSTAT_SERVICEMODE    DF_VAL32S(0x1U, 14, 1)

/* AVR uC "VN=" response */
typedef struct _AvrResponseVersion {
	uint16_t nMajorRelease;
	uint16_t nMinorRelease;
	uint16_t nMajorBuild;
	uint16_t nMinorBuild;
} AvrResponseVersion;

/* AVR FMC Status field values */
#define AVR_FMCSTATUS_V_PRSNT     (0x1U << 0) /* FMC & XRM */
#define AVR_FMCSTATUS_V_PWROK_C2M (0x1U << 1) /* FMC only */
#define AVR_FMCSTATUS_V_PWROK_M2C (0x1U << 2) /* FMC only */
#define AVR_FMCSTATUS_V_I2CFAIL   (0x1U << 3) /* FMC & XRM */
#define AVR_FMCSTATUS_V_CSUMERR   (0x1U << 4) /* FMC & XRM */
#define AVR_FMCSTATUS_V_NODATA    (0x1U << 5) /* FMC & XRM */
#define AVR_XRMSTATUS_V_FORCE2V5  (0x1U << 6) /* XRM only */

#endif
