/*
** File: adpexrc6t.h  
** Project: ADB3 core driver
** Purpose: Definitions specific to ADPE-XRC-6T(L).
**
** (C) Copyright Alpha Data 2012
*/

#ifndef _ADATA_CORE_ADPEXRC6T_H
#define _ADATA_CORE_ADPEXRC6T_H

#include <df.h>
#include "adb3.h"
#include "admxrc6tx.h"

#define ADPEXRC6T_NUM_DMA_CHANNEL  (4)
#define ADPEXRC6TL_NUM_DMA_CHANNEL (2)

#define ADPEXRC6T_INCLUDE_SI5338_INTERFACE (1)

/* Offset of FMC Status field in sensor data block in model-specific registers */
#define ADPEXRC6T_SENSOR_OFFSET_FMCSTATUS (0x2AU)

/* Always LITTLE ENDIAN when stored in hardware */
#pragma pack(1)
typedef struct _VpdAdpexrc6tRev0 {
	uint16_t version;         /* 0x00 Revision of this structure (0) */
	uint16_t length;          /* 0x02 Length of this structure including checksum */
	uint32_t serial;          /* 0x04 Board serial number */
	uint32_t modifications;   /* 0x08 Modifications bitmap - see definitions below */
  uint8_t  tempGrade;       /* 0x0C Temperature grade - see definitions below */
  uint8_t  _reserved1;      /* 0x0D */
	uint8_t  pcbRev;          /* 0x0E PCB revision 0xAB where A = major, B = minor */
  uint8_t  _reserved2;      /* 0x0F */
	uint32_t si5338Ref;       /* 0x10 Frequency of SI5338 reference oscillator, in Hz */
	uint32_t idelayRef;       /* 0x14 IDELAY reference clock frequency, in Hz */
	uint32_t gtpRef;          /* 0x18 GTP/GTX reference clock frequency, in Hz */
  uint32_t _reserved3;      /* 0x1C */
	struct {
		uint16_t speed;         /* 0x20, 0x28, 0x30, 0x38 Device maximum clock frequency, in units of 100 kHz */
		uint8_t	 order;         /* 0x22, 0x2A, 0x32, 0x3A Log base 2 of size of bank, in words */
    uint8_t  _reserved4;    /* 0x23, 0x2B, 0x33, 0x3B */
    uint16_t link;          /* 0x24, 0x2C, 0x34, 0x3C Byte offset in VPD of extended info, or 0 if none */
    uint16_t _reserved5;    /* 0x26, 0x2E, 0x36, 0x3E */
	} sdram[2];
  struct {
    uint8_t  stepping[8];   /* 0x40 Stepping level of target FPGA (ASCII NUL-terminated string) */
    uint8_t  speedGrade[4]; /* 0x48 Speed grade of target FPGA (ASCII NUL-terminated string) */
    uint16_t device;        /* 0x4C Device code, as per ADMXRC3_FPGA_TYPE */
    uint16_t _reserved6;    /* 0x4E */
  } fpga;
  uint8_t  checksum;        /* 0x50 This MUST ALWAYS be the last member in the struct */
} VpdAdpexrc6tRev0;         /* Total 0x51 bytes */
#pragma pack()

/* Values for VpdAdpexrc6tRev0::modifications */

/* Values for VpdAdpexrc6tRev0::fpga::tempGrade */
#define ADPEXRC6T_VPD_TEMPGRADE_COMMERCIAL  ADMXRC6Tx_VPD_TEMPGRADE_COMMERCIAL
#define ADPEXRC6T_VPD_TEMPGRADE_INDUSTRIAL  ADMXRC6Tx_VPD_TEMPGRADE_INDUSTRIAL
#define ADPEXRC6T_VPD_TEMPGRADE_EXTENDED    ADMXRC6Tx_VPD_TEMPGRADE_EXTENDED

#if ADPEXRC6T_INCLUDE_SI5338_INTERFACE
/* Values for ADMXRC6Tx_V_I2CCTL_I2CADDR() */
# define ADPEXRC6T_I2C_SLOT_SI5338           (0x70U)
#endif

/* Fields for ModelRegsAdmxrc6tx::intCtl */
#define ADPEXRC6T_V_INTCTL_ADVRXNE    DF_VAL32S(0x1U, 5, 1)  /* AVR uC RX FIFO not empty interrupt enable */
#define ADPEXRC6T_V_INTCTL_ADVTXE     DF_VAL32S(0x1U, 7, 1)  /* AVR uC TX FIFO empty interrupt enable */
#define ADPEXRC6T_V_INTCTL_LS_ADVRXNE DF_VAL32S(0x1U, 13, 1) /* 1 => AVR uC RX FIFO not empty interrupt is level-sensitive */
#define ADPEXRC6T_V_INTCTL_LS_ADVTXE  DF_VAL32S(0x1U, 15, 1) /* 1 => AVR uC TX FIFO empty interrupt is level-sensitive */

#define ADPEXRC6T_V_INTCTL_LEVELBITS (ADMXRC6Tx_V_INTCTL_SYSLEVEL | ADPEXRC6T_V_INTCTL_LS_ADVRXNE | ADPEXRC6T_V_INTCTL_LS_ADVTXE)

/* Fields for ModelRegsAdmxrc6tx::intStat */
#define ADPEXRC6T_V_INTSTAT_ADVRXNE   DF_VAL32S(0x1U, 5, 1)  /* AVR uC RX FIFO not empty interrupt active */
#define ADPEXRC6T_V_INTSTAT_ADVTXE    DF_VAL32S(0x1U, 7, 1)  /* AVR uC TX FIFO empty interrupt active */

#define ADPEXRC6T_V_INTSTAT_LEVELBITS (ADMXRC6Tx_V_INTSTAT_SYS | ADPEXRC6T_V_INTSTAT_ADVRXNE | ADPEXRC6T_V_INTSTAT_ADVTXE)

/* AVR uC NV memory info */
#define ADPEXRC6T_AVR_FLASH_PAGE_SIZE    (0x100U) /* Size in bytes of a Flash memory page in AVR uC */
#define ADPEXRC6T_AVR_FLASH_SIZE       (0x10000U) /* Size in bytes of Flash memory in AVR uC */
#define ADPEXRC6T_AVR_FLASH_VPD_OFFSET  (0xFF00U) /* Offset (bytes) into of Flash memory in AVR uC where VPD is located */

#endif
