/*
** File: admxrcku1.h  
** Project: ADB3 core driver
** Purpose: Definitions specific to ADM-XRC-KU1.
**
** (C) Copyright Alpha Data 2015
*/

#ifndef _ADATA_CORE_ADMXRCKU1_H
#define _ADATA_CORE_ADMXRCKU1_H

#include <df.h>
#include "adb3.h"
#include "admxrc6tx.h"

#define ADMXRCKU1_NUM_DMA_CHANNEL       (2) /* Number of DMA engines in Bridge */
#define ADMXRCKU1_NUM_DMA_CHANNEL_P5_P6 (4) /* Max. number of DMA engines in P5 or P6 endpoint */

/* Number of clocks programmable via AVR (some may be not be user-programmable) */
#define ADMXRCKU1_NUM_AVR2_CLOCK (4)
/* Number of user-programmable clocks programmable via AVR */
#define ADMXRCKU1_NUM_AVR2_USER_CLOCK (2)

/* Offset of XRM Status field in sensor data block in model-specific registers */
#define ADMXRCKU1_SENSOR_OFFSET_MEZ_STAT0 (44U)

/* Always LITTLE ENDIAN when stored in hardware */
#pragma pack(1)
typedef struct _VpdAdmxrcku1Rev0 {
	uint16_t version;          /* 0x00 Revision of this structure (0) */
	uint16_t length;           /* 0x02 Length of this structure including checksum */
  uint32_t partNumber;       /* 0x04 Part number (1305 => ADM-XRC-KU1) */
	uint32_t serial;           /* 0x08 Board serial number */
	uint32_t modifications;    /* 0x0C Modifications bitmask; see definitions below */
  uint8_t  coolingType;      /* 0x10 Cooling type: 0 => Air-cooled commerical, 1 => /AC1 - Air-cooled industrial, 2 => /CC1 - Conduction-cooled industrial */
  uint8_t  coatingType;      /* 0x11 Coating type: 0 => No coating, 1 => /A - Acrylic (Humiseal 1B31), 2 => /P - Polyurethane (Conathane CE-1155) */
  uint8_t  pn4Fitted;        /* 0x12 0 => Pn4 is not fitted, 1 => /Pn4 - Pn4 is fitted */
  uint8_t  _reserved1;       /* 0x13 */
	uint32_t si5338Ref;        /* 0x14 Frequency of SI5338 reference oscillator, in Hz */
  uint32_t _reserved2;       /* 0x18 */
  uint32_t _reserved3;       /* 0x1C */
  uint32_t _reserved4;       /* 0x20 */
  uint32_t _reserved5;       /* 0x24 */
	struct {
		uint16_t speed;          /* 0x28, 0x30, 0x38, 0x40 In units of 100 kHz */
		uint8_t	 order;          /* 0x2A, 0x32, 0x3A, 0x42 Log base 2 of size in words */
    uint8_t  _reserved2;     /* 0x2B, 0x33, 0x3B, 0x43 */
    uint16_t link;           /* 0x2C, 0x34, 0x3C, 0x44 Byte offset in VPD of extended info */
    uint16_t _reserved3;     /* 0x2E, 0x36, 0x3E, 0x46 */
	} sdram[4];
  struct {
    uint8_t  stepping[8];    /* 0x48 Stepping level of target FPGA */
    uint8_t  speedGrade[4];  /* 0x50 Speed grade of target FPGA */
    uint16_t device;         /* 0x54 Device code of target FPGA */
    uint8_t  tempGrade;      /* 0x56 Temperature grade of target FPGA; see definitions below */
    uint8_t  _reserved4;     /* 0x57 */
  } fpga;
	uint8_t  pcbRev;           /* 0x58 PCB revision 0xAB where A is major, B is minor */
  uint8_t  checksum;         /* 0x59 This MUST ALWAYS be the last member in the struct */
} VpdAdmxrcku1Rev0;
#pragma pack()

/* Values for VpdAdmxrcku1Rev0::modifications */

/* Values for VpdAdmxrcku1Rev0::fpga::tempGrade */
#define ADMXRCKU1_VPD_TEMPGRADE_COMMERCIAL  ADMXRC6Tx_VPD_TEMPGRADE_COMMERCIAL
#define ADMXRCKU1_VPD_TEMPGRADE_INDUSTRIAL  ADMXRC6Tx_VPD_TEMPGRADE_INDUSTRIAL
#define ADMXRCKU1_VPD_TEMPGRADE_EXTENDED    ADMXRC6Tx_VPD_TEMPGRADE_EXTENDED

/* Fields for ModelRegsAdmxrc6tx::intCtl */
#define ADMXRCKU1_V_INTCTL_AVR2RXNE    DF_VAL32S(0x1U, 5, 1)  /* AVR2 interface RX FIFO not empty interrupt enable */
#define ADMXRCKU1_V_INTCTL_AVR2TXE     DF_VAL32S(0x1U, 6, 1)  /* AVR2 interface TX FIFO empty interrupt enable */
#define ADMXRCKU1_V_INTCTL_LS_AVR2RXNE DF_VAL32S(0x1U, 13, 1) /* 1 => AVR2 interface RX FIFO not empty interrupt is level-sensitive */
#define ADMXRCKU1_V_INTCTL_LS_AVR2TXE  DF_VAL32S(0x1U, 14, 1) /* 1 => AVR2 interface TX FIFO empty interrupt is level-sensitive */

#define ADMXRCKU1_V_INTCTL_LEVELBITS (ADMXRC6Tx_V_INTCTL_SYSLEVEL | ADMXRCKU1_V_INTCTL_LS_AVR2RXNE | ADMXRCKU1_V_INTCTL_LS_AVR2TXE)

/* Fields for ModelRegsAdmxrc6tx::intStat */
#define ADMXRCKU1_V_INTSTAT_AVR2RXNE   DF_VAL32S(0x1U, 5, 1)  /* AVR2 interface RX FIFO not empty interrupt active */
#define ADMXRCKU1_V_INTSTAT_AVR2TXE    DF_VAL32S(0x1U, 6, 1)  /* AVR2 interface TX FIFO empty interrupt active */

#define ADMXRCKU1_V_INTSTAT_LEVELBITS (ADMXRC6Tx_V_INTSTAT_SYS | ADMXRCKU1_V_INTSTAT_AVR2RXNE | ADMXRCKU1_V_INTSTAT_AVR2TXE)

/* AVR uC NV memory info */
#define ADMXRCKU1_AVR_FLASH_PAGE_SIZE_LOG2 (0x9U)     /* Log2(Size in bytes of a Flash memory page in AVR uC) */
#define ADMXRCKU1_AVR_FLASH_SIZE           (0x20000U) /* Size in bytes of Flash memory in AVR uC */
#define ADMXRCKU1_AVR_FLASH_VPD_OFFSET     (0x1FF00U) /* Offset (bytes) into of Flash memory in AVR uC where VPD is located */

#endif
