/*
** File: admpcie6s1.h  
** Project: ADB3 core driver
** Purpose: Definitions specific to ADM-PCIE-6S1
**
** (C) Copyright Alpha Data 2014
*/

#if !defined(_ADATA_CORE_ADMPCIE6S1_H)
#define _ADATA_CORE_ADMPCIE6S1_H

#include "pci9xxx.h"

/* Model-specific registers in PCI9xxx BAR3 */
#pragma pack(1)
typedef struct _ModelRegsAdmpcie6s1 {
  uint8_t fcon;           /* 0x00 */
  uint8_t ccon;           /* 0x01 */
  uint8_t imset;          /* 0x02 */
  uint8_t imclr;          /* 0x03 */
  uint8_t icon;           /* 0x04 */
  uint8_t pstat;          /* 0x05 */
  uint8_t mode;           /* 0x06 */
  uint8_t flpage;         /* 0x07 */
  uint8_t smap[4];        /* 0x08 */
  uint8_t _reserved1[4];  /* 0x0C */
} ModelRegsAdmpcie6s1;    /* 0x10 */
#pragma pack()

/* Fields for ModelRegsAdmpcie6s1::fcon */
#define ADMPCIE6S1_FCON_PROG ((uint8_t)(1U << 0))
#define ADMPCIE6S1_FCON_INIT ((uint8_t)(1U << 1))
#define ADMPCIE6S1_FCON_DONE ((uint8_t)(1U << 2))

/* Fields for ModelRegsAdmpcie6s1::icon register */
#define ADMPCIE6S1_ICON_FPGA (0x1U << 0)

/* Fields for ModelRegsAdmpcie6s1::ccon register */
#define ADMPCIE6S1_CCON_SCL (0x1U << 0) /* Write 1 to CCON[0] => drive SCL low; reading CCON[0] gives actual level on SCL. */
#define ADMPCIE6S1_CCON_SDA (0x1U << 1) /* Write 1 to CCON[1] => drive SDA low; reading CCON[1] gives actual level on SDA */

/* Vital Product data; always LITTLE ENDIAN when stored in hardware */
#pragma pack(1)
typedef struct _VpdAdmpcie6s1Rev0 {
  uint32_t serialNumber;  /* 0x00 (0x68) Serial number */
  uint16_t cardId;        /* 0x04 (0x6C) Card ID */
  uint16_t modifications; /* 0x06 (0x6E) Bitmap; nothing defined yet */
  uint32_t si5338RefClk;  /* 0x08 (0x70) SI5338 reference clock frequency, in Hz */
  uint8_t fpgaSCD[4];     /* 0x0C (0x74) FPGA SCD code, nul-terminated */
  uint8_t fpgaSpeedGrade; /* 0x10 (0x78) FPGA speed grade; bits [3:0] = speed grade (1, 2, 3), bit [4] = 1 => -N (no MCB) */
  uint8_t fpgaTempGrade;  /* 0x11 (0x79) FPGA temperature grade; 0 => commercial, 1 => industrial */
  uint16_t fpgaType;      /* 0x12 (0x7A) FPGA device code (as per ADMXRC2_FPGA_TYPE) */
  uint8_t  cpldRev;       /* 0x14 (0x7C) CPLD revision */
  uint8_t  pcbRev;        /* 0x15 (0x7D) Board revision */
  uint16_t _reserved1;    /* 0x16 (0x7E) (Reserved) */
} VpdAdmpcie6s1Rev0;      /* 0x18 (0x80) */
#pragma pack()

/* Byte address of VpdAdmpcie6s1Rev0 structure in PCI9056's configuration EEPROM */
#define ADMPCIE6S1_EEPROM_VPD_OFFSET (0x68U)

/* I2C slot address of SI5338 */
#define ADMPCIE6S1_I2C_SLOT_SI5338 (0x70U)

#endif
