/*
** File: adb1_common.h  
** Project: ADB1 core driver
** Purpose: Definitions for ADB1 common routines.
**
** (C) Copyright Alpha Data 2013
*/

#ifndef _ADATA_CORE_ADB1_COMMON_H
#define _ADATA_CORE_ADB1_COMMON_H

#include "device.h"
#include "adb1.h"

extern void
adb1DumpDmaDescriptors(
  Adb3CoreDeviceContext* pDevCtx,
  Adb1DmaDescriptor* pDescriptors,
  uint64_t descBus,
  unsigned int count);

extern void
adb1DumpDmaRegisters(
  Adb3CoreDeviceContext* pDevCtx,
  unsigned int channel);

extern void
adb1DmaList(
  Adb3CoreDeviceContext* pDevCtx,
  boolean_t bWriteToDevice,
  boolean_t bFixedLocal,
  DfDmaMapperNode* pTable,
  unsigned int tableLength,
  DmaNodeTablePosition* pTablePosition,
  void* pDescriptorBuffer,
  unsigned int maxDescriptor,
  uint64_t descriptorBusAddress);

extern void
adb1DmaTransfer(
  Adb3CoreDeviceContext* pDevCtx,
  unsigned int channel,
  boolean_t bStart,
  void* pDescriptorBuffer,        /* Valid iff 'bStart' is TRUE */
  uint64_t descriptorBusAddress); /* Valid iff 'bStart' is TRUE */

extern void
adb1EnableDmaEngines(
  Adb3CoreDeviceContext* pDevCtx,
  boolean_t bEnable);

extern void
adb1EnableInterrupts(
  Adb3CoreDeviceContext* pDevCtx,
  boolean_t bEnable);

extern CoreWindowConfigStatus
adb1WindowConfig(
	Adb3CoreDeviceContext* pDevCtx,
  unsigned int windowIndex,
  boolean_t bConfigure,
  uint32_t flags,
  CoreWindowConfig* pConfig);

#endif
