################################################################################
#	Makefile settings for TMS System
################################################################################
#
include ${TOP}/Config.mk

# CERN Internal BUILD
#BUILD_ENV	= CERN

# The BUILD type
BUILD		?= FULL
#BUILD		?= CLIENT
#BUILD		?= LIB
BEAMLIB_BUILD	= LINUX

#CONFDIR	= $(DEST_DIR)$(PREFIX)/config

# Build Settings
SRCINCDIR	= ${TOP}/tms/include
SRCLIBDIR	= ${TOP}/tms/${ARCH_LIB}/$(CPU)
INCDIRS		= -I${SRCINCDIR} -I${SRCINCDIR}/Beam
LIBDIRS		= -L${SRCLIBDIR}

# Debian
INCDIRS		+= -I/usr/include/x86_64-linux-gnu	

DEBUGFLAGS	= -O2

CXXFLAGS	+= $(DEBUGFLAGS)
CXXFLAGS	+= -m64 -fPIC
CXXFLAGS	+= -MMD
CXXFLAGS	+= -Wall -Wno-parentheses -Wreturn-type -Wno-conversion
CXXFLAGS	+= -Wno-deprecated -Wno-write-strings
CXXFLAGS	+= -DCERN_TMS
CXXFLAGS	+= -D_GNU_SOURCE
CXXFLAGS	+= -I. $(INCDIRS) -DVERSION=\"$(VERSION)\"

CFLAGS		= $(CXXFLAGS)
LDFLAGS		+= $(LIBDIRS) $(DEBUGFLAGS)
LDLIBS		+= -lBeam -lpthread
CXX		= g++
CC		= g++
RANLIB		= true
