/*
** sensors.h - structures supporting ADMXRC2 API sensor extension.
**
** (C) Copyright 2014 Alpha Data
*/

#ifndef _ADATA_ADMXRC2_SENSORS_H
#define _ADATA_ADMXRC2_SENSORS_H

#include <admxrc2/sensort.h>

typedef union _ADMXRC2_SENSOR_VALUE {
  _ADMXRC2_BOOL   Bool;
  double          Double;
  _ADMXRC2_INT32  Int32;
  _ADMXRC2_UINT32 UInt32;
} ADMXRC2_SENSOR_VALUE;

typedef struct _ADMXRC2_SENSOR_INFO {
  char              Description[28];
  _ADMXRC2_UINT32   Capabilities;
  double            Error;            /* As a fraction or multiple of Unit * Exponent */
  ADMXRC2_DATA_TYPE DataType;
  ADMXRC2_UNIT_TYPE Unit;
  int               Exponent;         /* Power of 10 */
} ADMXRC2_SENSOR_INFO;

#endif
