#ifndef _ADATA_ADMXRC2_PLATFORM_H
#define _ADATA_ADMXRC2_PLATFORM_H

/*
** platform.h - define elementary datatypes used by ADMXRC2 API
**
** (C) Copyright Alpha Data 2013, 2014
**
** The integer datatypes defined below prefixed by "_ADMXRC2_", such as
** "_ADMXRC2_UINT32" are defined in order to increase the portability of
** this header file but should NOT be used by application code that
** makes use of the ADMXRC2 API.
*/

#if defined(_WIN32)

/* Windows */
typedef INT16   _ADMXRC2_INT16;
typedef WORD    _ADMXRC2_UINT16;
typedef BYTE    _ADMXRC2_UINT8;
typedef INT32   _ADMXRC2_INT32;
typedef UINT64  _ADMXRC2_UINT64;
typedef UINT32  _ADMXRC2_UINT32;
typedef DWORD   _ADMXRC2_DWORD;
typedef BYTE    _ADMXRC2_BYTE;
typedef BOOL    _ADMXRC2_BOOL;
typedef BOOLEAN _ADMXRC2_BOOLEAN;
typedef HANDLE  ADMXRC2_HANDLE;

/* This value is invalid for an ADMXRC2_HANDLE */ 
# define ADMXRC2_HANDLE_INVALID_VALUE (NULL)

#elif defined(__linux) || defined(__VXWORKS__) || defined(__vxworks)

/* Linux or VxWorks - assume C99-compliant */

# if defined(__linux)
#   include <stdint.h>
# endif

typedef int32_t  _ADMXRC2_INT32;
typedef int16_t  _ADMXRC2_INT16;
typedef uint64_t _ADMXRC2_UINT64;
typedef uint32_t _ADMXRC2_UINT32;
typedef uint32_t _ADMXRC2_DWORD;
typedef uint16_t _ADMXRC2_UINT16;
typedef uint8_t  _ADMXRC2_UINT8;
typedef uint8_t  _ADMXRC2_BYTE;
typedef int      _ADMXRC2_BOOL;
typedef int      _ADMXRC2_BOOLEAN;

typedef int      ADMXRC2_HANDLE;

/* This value is invalid for an ADMXRC2_HANDLE */ 
# define ADMXRC2_HANDLE_INVALID_VALUE (-1)

#else

# error Cannot detect target operating system.

#endif

#endif
