/*
** File: info.h  
** Project: ADMXRC2 module driver
** Purpose: Defines function prototypes for informational IOCTL handlers.
**
** (C) Copyright Alpha Data 2013
*/

#if !defined(ADATA_ADMXRC2_INFO_H)
#define ADATA_ADMXRC2_INFO_H

#include <df.h>
#include "device.h"
#include <admxrc2/types.h>

extern DfIoStatus
ioctlGetBankInfo(
	Admxrc2DeviceContext* pDevCtx,
  void* pBuffer,
  unsigned int inSize,
  unsigned int outSize);

extern DfIoStatus
ioctlGetCardInfo(
	Admxrc2DeviceContext* pDevCtx,
  void* pBuffer,
  unsigned int outSize);

extern DfIoStatus
ioctlGetFpgaInfo(
	Admxrc2DeviceContext* pDevCtx,
  void* pBuffer,
  unsigned int inSize,
  unsigned int outSize);

extern DfIoStatus
ioctlGetDriverVersion(
	Admxrc2DeviceContext* pDevCtx,
  void* pBuffer,
  unsigned int outSize);

#endif
