/*
** File: dma.h  
** Project: ADMXRC2 module driver
** Purpose: Defines function prototypes for DMA IOCTL handlers.
**
** (C) Copyright Alpha Data 2013
*/

#if !defined(ADATA_ADMXRC2_DMA_H)
#define ADATA_ADMXRC2_DMA_H

#include <df.h>
#include "device.h"

extern DfIoStatus
ioctlDoDma(
	Admxrc2DeviceContext* pDevCtx,
  Admxrc2ClientContext* pClCtx,
  DfClientRequest* pReq,
  void* pBuffer,
  unsigned int inSize,
  unsigned int outSize);

#if DF_NEED_THUNK
extern DfIoStatus
ioctlDoDmaThunk(
	Admxrc2DeviceContext* pDevCtx,
  Admxrc2ClientContext* pClCtx,
  DfClientRequest* pReq,
  void* pBuffer,
  unsigned int inSize,
  unsigned int outSize);
#endif

extern DfIoStatus
ioctlDoDmaImmediate(
	Admxrc2DeviceContext* pDevCtx,
  Admxrc2ClientContext* pClCtx,
  DfClientRequest* pReq,
  void* pBuffer,
  unsigned int inSize,
  unsigned int outSize);

#if DF_NEED_THUNK
extern DfIoStatus
ioctlDoDmaImmediateThunk(
	Admxrc2DeviceContext* pDevCtx,
  Admxrc2ClientContext* pClCtx,
  DfClientRequest* pReq,
  void* pBuffer,
  unsigned int inSize,
  unsigned int outSize);
#endif

extern void
cleanupDma(
	Admxrc2DeviceContext* pDevCtx,
  Admxrc2ClientContext* pClCtx);

#endif
