/*
** File: time.c  
** Project: Linux Driver Framework
** Purpose: Thread delay functions
**
** (C) Copyright Alpha Data 2010
*/

#include "df.h"
#include "dflinux.h"

boolean_t
dfDelayThreadUntil(
  DfTime when)
{
  long delay;
  boolean_t bInterrupted;

  set_current_state(TASK_INTERRUPTIBLE);
  delay = (long)(when - jiffies);
  if (delay <= 0) {
    set_current_state(TASK_RUNNING);
    return FALSE;
  }
  bInterrupted = schedule_timeout(delay) ? TRUE : FALSE;
  set_current_state(TASK_RUNNING);

  return bInterrupted;
}

boolean_t
dfDelayThreadFor(
  DfTime period)
{
  boolean_t bInterrupted;

  if (0 == period) {
    return FALSE;
  }
  set_current_state(TASK_INTERRUPTIBLE);
  bInterrupted = schedule_timeout((long)period) ? TRUE : FALSE;
  set_current_state(TASK_RUNNING);

  return bInterrupted;
}
