/*
** File: v4clksynth_common.h  
** Project: ADB3 core driver
** Purpose: Exports common functions for Virtex-4 DCM clock synthesizer
**
** (C) Copyright Alpha Data 2013
*/

#ifndef _ADATA_CORE_V4CLKSYNTH_COMMON_H
#define _ADATA_CORE_V4CLKSYNTH_COMMON_H

#include <df.h>
#include "device.h"
#include "v5clksynth.h"

extern V4ClkSynthClockWordStatus
v4ClkSynthClockWord(
  uint32_t flags,
	uint32_t refFrequency,
	uint64_t frequencyReq,
	uint64_t frequencyMin,
	uint64_t frequencyMax,
	CoreClockWord* pClockWord);

extern boolean_t
v4ClkSynthInit(
  Adb3CoreDeviceContext* pDevCtx,
  V4ClkSynthDeviceContext* pV4ClkSynthCtx,
  unsigned int lclkRef,
  uint32_t* pFOut);

extern void
v4ClkSynthUninit(
  Adb3CoreDeviceContext* pDevCtx,
  V4ClkSynthDeviceContext* pV4ClkSynthCtx);

extern V4ClkSynthProgramStatus
v4ClkSynthProgram(
  Adb3CoreDeviceContext* pDevCtx,
  V4ClkSynthDeviceContext* pV4ClkSynthCtx,
  V4ClkSynthProgramRequest* pRequest,
  const CoreClockWord* pClockWord,
  V4ClkSynthProgramCallback* pCallback);

/* Must be called in thread context */
extern V4ClkSynthProgramStatus
v4ClkSynthProgramSync(
  Adb3CoreDeviceContext* pDevCtx,
  V4ClkSynthDeviceContext* pV4ClkSynthCtx,
  const CoreClockWord* pClockWord);

/* Must be called in thread context */
extern void
v4ClkSynthSaveState(
  Adb3CoreDeviceContext* pDevCtx,
  V4ClkSynthDeviceContext* pV4ClkSynthCtx);

/* Must be called in thread context */
extern V4ClkSynthProgramStatus
v4ClkSynthRestoreState(
  Adb3CoreDeviceContext* pDevCtx,
  V4ClkSynthDeviceContext* pV4ClkSynthCtx);

/* Convenience functions */

extern ClockProgramStatus
v4ClkSynthMapProgramStatus(
  V4ClkSynthProgramStatus status);

extern ClockWordStatus
v4ClkSynthMapClockWordStatus(
  V4ClkSynthClockWordStatus status);

#endif
