/*
** File: ddr3_spd_common.h  
** Project: ADB3 core driver
** Purpose: Defines function prototypes for reading DDR3 DIMM SPD information via an I2C interface.
**
** (C) Copyright Alpha Data 2014
*/

#if !defined(ADATA_CORE_DDR3_SPD_COMMON_H)
#define ADATA_CORE_DDR3_SPD_COMMON_H

#include <df.h>
#include "ddr3_spd.h"
#include "i2c_common.h"

typedef struct _Ddr3DimmSummary {
  uint64_t physicalSize;  /* In words */
  unsigned int dataWidth; /* In bits */
  unsigned int eccWidth;  /* In bits */
  uint32_t freqMax;       /* Maximum operating frequency, in Hz */
  boolean_t bRomCorrupt;  /* TRUE => corruption detected in SPD ROM, FALSE => SPD ROM OK */
} Ddr3DimmSummary;

extern boolean_t
admxrc6txGetDdr3DimmSpd(
  I2cContext* pI2cCtx,
  uint8_t bus,
  uint8_t slot,
  Ddr3DimmSummary* pSummary, /* May be NULL */
  uint8_t* pRaw);            /* If not NULL, must point to a buffer of at least DDR3_SPD_ROM_SIZE bytes */

#endif
