/*
** File: corefpga.c  
** Project: ADB3 core driver
** Purpose: Implemented target FPGA Core Interface functions.
**
** (C) Copyright Alpha Data 2009-2010
*/

#include <df.h>
#include "corefpga.h"
#include "device.h"
#include "resource.h"

CoreFpgaControlStatus
coreFpgaControl(
  void* pInterfaceContext,
  CoreTicket* pTicket,
  unsigned int targetIndex,
  CoreFpgaControlOp operation,
  boolean_t* pbValue)
{
  Adb3CoreDeviceContext* pDevCtx = (Adb3CoreDeviceContext*)pInterfaceContext;

  if (!checkTicketValid(pDevCtx, pTicket, CORE_RESOURCE_TARGETFPGA, targetIndex)) {
    return CoreFpgaControlInvalidTicket;
  }

  return (CoreFpgaControlStatus)pDevCtx->methods.pFpgaControl(pDevCtx, targetIndex, operation, pbValue);
}

CoreFpgaSelectMapStatus
coreFpgaSelectMap(
  void* pInterfaceContext,
  CoreTicket* pTicket,
  unsigned int targetIndex,
  boolean_t bWrite,
  size_t length,
  void* pBuffer)
{
  Adb3CoreDeviceContext* pDevCtx = (Adb3CoreDeviceContext*)pInterfaceContext;

  if (!checkTicketValid(pDevCtx, pTicket, CORE_RESOURCE_TARGETFPGA, targetIndex)) {
    return CoreFpgaSelectMapInvalidTicket;
  }

  return (CoreFpgaSelectMapStatus)pDevCtx->methods.pFpgaSelectMap(pDevCtx, targetIndex, bWrite, length, pBuffer);
}

unsigned int
coreGetNumTargetFpga(
  void* pInterfaceContext)
{
  Adb3CoreDeviceContext* pDevCtx = (Adb3CoreDeviceContext*)pInterfaceContext;

  return pDevCtx->info.bootstrap.numTargetFpga;
}
