/*
** File: avr2_flash.h  
** Project: ADB3 core driver
** Purpose: Exports definitions for accessing the AVR uC's Flash memory
**
** (C) Copyright Alpha Data 2015
**
** These functions will work correctly only if the AVR uC is in service mode.
** If not in service mode, the result of calling these functions will be
** Avr2FlashNotServiceMode.
*/

#ifndef _ADATA_CORE_AVR2_FLASH_H
#define _ADATA_CORE_AVR2_FLASH_H

#include "avr2_common.h"

typedef enum _Avr2FlashStatus {
  Avr2FlashSuccess         = 0,    /* Success */
  Avr2FlashTimeout         = 1,    /* AVR uC didn't respond within allotted time */
  Avr2FlashNotServiceMode  = 2,    /* AVR uC is not in service mode */
  Avr2FlashInvalidRegion   = 3,    /* 'address' and/or 'length' were out of bounds for size of Flash in AVR uC */
  Avr2FlashGeneralFailure  = 4,    /* Failed for reason that can't be determined */
  Avr2FlashHardwareFailure = 0x100
} Avr2FlashStatus;

/* Must be called in thread context */
extern Avr2FlashStatus
avr2FlashRead(
	Adb3CoreDeviceContext* pDevCtx,
  Avr2DeviceContext* pAvr2Ctx,
  uint32_t address,      /* uC Flash memory space byte address */
  uint32_t length,       /* in bytes */
  uint8_t* pBuffer);     /* Buffer to hold data read */

/* Must be called in thread context */
extern Avr2FlashStatus
avr2FlashWrite(
	Adb3CoreDeviceContext* pDevCtx,
  Avr2DeviceContext* pAvr2Ctx,
  uint32_t address,      /* uC Flash memory space byte address */
  uint32_t length,       /* in bytes */
  const uint8_t* pData); /* Data to be written */

/* Must be called in thread context */
extern Avr2FlashStatus
avr2FlashErase(
	Adb3CoreDeviceContext* pDevCtx,
  Avr2DeviceContext* pAvr2Ctx,
  uint32_t address,      /* uC Flash memory space byte address */
  uint32_t length);      /* in bytes */

#endif
