/*
** File: admpcie8k5.h  
** Project: ADB3 core driver
** Purpose: Definitions specific to ADM-PCIE-8K5.
**
** (C) Copyright Alpha Data 2016
*/

#ifndef _ADATA_CORE_ADMPCIE8K5_H
#define _ADATA_CORE_ADMPCIE8K5_H

#include <df.h>
#include "adb3.h"
#include "admxrc6tx.h"
#include "ddr3_spd.h"

#define ADMPCIE8K5_NUM_DMA_CHANNEL (4)

/* Number of SI5338 clock outputs programmable via AVR (some may be not be user-programmable) */
/* All four SI5338 outputs are considered user-programmable */
#define ADMPCIE8K5_NUM_AVR2_CLOCK (4)

/* Always LITTLE ENDIAN when stored in hardware */
#pragma pack(1)
typedef struct _VpdAdmpcie8k5Rev0 {
	uint16_t version;          /* 0x00 Revision of this structure (0) */
	uint16_t length;           /* 0x02 Length of this structure including checksum */
	uint32_t partNumber;       /* 0x04 Part number: 1319 => ADM-PCIE-8K5 */
	uint32_t serial;           /* 0x08 Board serial number */
	uint8_t  pcbRev;           /* 0x0C PCB revision 0xAB where A is major, B is minor */
  uint8_t  modifications;    /* 0x0D Modifications bitmask; see below */
  uint16_t _reserved1;       /* 0x0E */
	uint32_t si5338Ref;        /* 0x10 Frequency of SI5338 reference oscillator, in Hz */
  uint32_t _reserved2;       /* 0x14 */
  uint32_t _reserved3;       /* 0x18 */
  uint32_t _reserved4;       /* 0x1C */
  uint32_t _reserved5;       /* 0x20 */
  uint32_t emcclkFreq;       /* 0x24 Frequency of EMCCLK oscillator, in Hz */
	uint32_t fabricClkFreq;    /* 0x28 Frequency of FABRIC_CLK oscillator, in Hz */
  uint32_t _reserved6;       /* 0x2C */
	struct {
		uint16_t speed;          /* 0x30, 0x38 In units of 100 kHz */
		uint8_t	 order;          /* 0x32, 0x3A Log base 2 of size in words */
    uint8_t  ranks;          /* 0x33, 0x3B Number of ranks */
    uint32_t _reserved7;     /* 0x34, 0x3C */
	} sdram[2];
  struct {
    uint8_t  stepping[8];    /* 0x40 Stepping level of target FPGA */
    uint8_t  speedGrade[4];  /* 0x48 Speed grade of target FPGA */
    uint16_t device;         /* 0x4C Device code of target FPGA */
    uint8_t  tempGrade;      /* 0x4E Temperature grade of target FPGA; see definitions below */
    uint8_t  _reserved8;     /* 0x4F */
  } fpga;
  uint8_t  checksum;         /* 0x50 This MUST ALWAYS be the last member in the struct */
} VpdAdmpcie8k5Rev0;
#pragma pack()

#pragma pack(1)
typedef struct VpdAdmpcie8k5 {
  VpdAdmpcie8k5Rev0 rev0;
} VpdAdmpcie8k5;
#pragma pack()

/* Values for VpdAdmpcie8k5Rev0::modifications */
#define ADMPCIE8K5_VPD_MOD_FITTED_RS232   (0x1U << 0U) /* RS232 converter is fitted */
#define ADMPCIE8K5_VPD_MOD_FITTED_ZQSFP   (0x1U << 1U) /* zQSFP modules are fitted */
#define ADMPCIE8K5_VPD_MOD_FITTED_FIREFLY (0x1U << 2U) /* FireFly modules are fitted */

/* Values for VpdAdmpcie8k5Rev0::fpga::tempGrade */
#define ADMPCIE8K5_VPD_TEMPGRADE_COMMERCIAL  ADMXRC6Tx_VPD_TEMPGRADE_COMMERCIAL
#define ADMPCIE8K5_VPD_TEMPGRADE_INDUSTRIAL  ADMXRC6Tx_VPD_TEMPGRADE_INDUSTRIAL
#define ADMPCIE8K5_VPD_TEMPGRADE_EXTENDED    ADMXRC6Tx_VPD_TEMPGRADE_EXTENDED

/* Fields for ModelRegsAdmxrc6tx::intCtl */
#define ADMPCIE8K5_V_INTCTL_AVR2RXNE    DF_VAL32S(0x1U, 5, 1)  /* AVR2 interface RX FIFO not empty interrupt enable */
#define ADMPCIE8K5_V_INTCTL_AVR2TXE     DF_VAL32S(0x1U, 6, 1)  /* AVR2 interface TX FIFO empty interrupt enable */
#define ADMPCIE8K5_V_INTCTL_LS_AVR2RXNE DF_VAL32S(0x1U, 13, 1) /* 1 => AVR2 interface RX FIFO not empty interrupt is level-sensitive */
#define ADMPCIE8K5_V_INTCTL_LS_AVR2TXE  DF_VAL32S(0x1U, 14, 1) /* 1 => AVR2 interface TX FIFO empty interrupt is level-sensitive */

#define ADMPCIE8K5_V_INTCTL_LEVELBITS (ADMXRC6Tx_V_INTCTL_SYSLEVEL | ADMPCIE8K5_V_INTCTL_LS_AVR2RXNE | ADMPCIE8K5_V_INTCTL_LS_AVR2TXE)

/* Fields for ModelRegsAdmxrc6tx::intStat */
#define ADMPCIE8K5_V_INTSTAT_AVR2RXNE   DF_VAL32S(0x1U, 5, 1)  /* AVR2 interface RX FIFO not empty interrupt active */
#define ADMPCIE8K5_V_INTSTAT_AVR2TXE    DF_VAL32S(0x1U, 6, 1)  /* AVR2 interface TX FIFO empty interrupt active */

#define ADMPCIE8K5_V_INTSTAT_LEVELBITS (ADMXRC6Tx_V_INTSTAT_SYS | ADMPCIE8K5_V_INTSTAT_AVR2RXNE | ADMPCIE8K5_V_INTSTAT_AVR2TXE)

/* AVR uC NV memory info */
#define ADMPCIE8K5_AVR_FLASH_PAGE_SIZE_LOG2 (0x9U)     /* Log2(Size in bytes of a Flash memory page in AVR uC) */
#define ADMPCIE8K5_AVR_FLASH_SIZE           (0x20000U) /* Size in bytes of Flash memory in AVR uC */
#define ADMPCIE8K5_AVR_FLASH_VPD_OFFSET     (0x1FF00U) /* Offset (bytes) into of Flash memory in AVR uC where VPD is located */

/* Delay counter in IPROG reconfiguration logic operates from LCLK, 40 MHz */
#define ADMPCIE8K5_IPROG_DELAYCNT_FREQ_HZ (40000000U)

#endif
