/*
** File: debugts.c  
** Project: ADMXRC2 API module library - Debug Timestamping extension
** Purpose: OS-independent code for ADMXRC2 API module library
**
** (C) Copyright Alpha Data 2016
*/

#include <admxrc2.h>
#include <admxrc2_platform.h>
#include <admxrc2/debugts.h>
#include "ioctl_admxrc2.h"

#define ARRAY_LENGTH(x) (sizeof(x) / sizeof((x)[0]))

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_GetDebugTSInfo(
  ADMXRC2_HANDLE hCard,
  _ADMXRC2_UINT32 facility,
  ADMXRC2_DEBUGTS_INFO* pDebugTSInfo)
{
  IOCTLS_ADMXRC2_GETDEBUGTSINFO ioctl;
  ADMXRC2_STATUS status;

  ioctl.in.facility = facility;
  status = admxrc2Ioctl(hCard, ADMXRC2_IOCTLCODE_GETDEBUGTSINFO, &ioctl, NULL, sizeof(ioctl.in), sizeof(ioctl.out));
  if (ADMXRC2_SUCCESS == status) {
    if (NULL != pDebugTSInfo) {
      pDebugTSInfo->Frequency = ioctl.out.frequency;
      pDebugTSInfo->InitTimestamp = ioctl.out.initTimestamp;
#if defined(_WIN32)
      pDebugTSInfo->InitTime.dwLowDateTime = (DWORD)(ioctl.out.initTime >> 0);
      pDebugTSInfo->InitTime.dwHighDateTime = (DWORD)(ioctl.out.initTime >> 32);
#elif defined(__linux)
      pDebugTSInfo->InitTime.tv_sec = (time_t)(uint32_t)(ioctl.out.initTime >> 32);
      pDebugTSInfo->InitTime.tv_usec = (suseconds_t)(uint32_t)(ioctl.out.initTime >> 0);
#else
# error Cannot detect target operating system.
#endif
      pDebugTSInfo->BufferSize = ioctl.out.bufferSize;
    }
  }

  return status;
}

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_GetDebugTSStatus(
  ADMXRC2_HANDLE hCard,
  _ADMXRC2_UINT32 facility,
  ADMXRC2_DEBUGTS_STATUS* pDebugTSStatus)
{
  IOCTLS_ADMXRC2_GETDEBUGTSSTATUS ioctl;
  ADMXRC2_STATUS status;

  ioctl.in.facility = facility;
  status = admxrc2Ioctl(hCard, ADMXRC2_IOCTLCODE_GETDEBUGTSSTATUS, &ioctl, NULL, sizeof(ioctl.in), sizeof(ioctl.out));
  if (ADMXRC2_SUCCESS == status) {
    pDebugTSStatus->Count = ioctl.out.count;
    pDebugTSStatus->Status = ioctl.out.status;
  }

  return status;
}

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_ReadDebugTS(
  ADMXRC2_HANDLE hCard,
  _ADMXRC2_UINT32 facility,
  size_t offset,
  size_t count,
  _ADMXRC2_UINT32 flags,
  void* pTSBuffer)
{
  IOCTLS_ADMXRC2_READDEBUGTS ioctl;

  ioctl.in.facility = facility;
  ioctl.in.offset = offset;
  ioctl.in.count = count;
  ioctl.in.flags = flags;
  ioctl.in.pBuffer = pTSBuffer;
  return admxrc2Ioctl(hCard, ADMXRC2_IOCTLCODE_READDEBUGTS, &ioctl, NULL, sizeof(ioctl.in), 0);
}

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_ResetDebugTS(
  ADMXRC2_HANDLE hCard,
  _ADMXRC2_UINT32 facility)
{
  IOCTLS_ADMXRC2_RESETDEBUGTS ioctl;

  ioctl.in.facility = facility;
  return admxrc2Ioctl(hCard, ADMXRC2_IOCTLCODE_RESETDEBUGTS, &ioctl, NULL, sizeof(ioctl.in), 0);
}
